/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.tests.utils;

import java.io.File;
import java.security.PrivateKey;
import java.util.HashMap;
import javax.crypto.SecretKey;
import junit.framework.TestCase;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.tests.XMLSecurityToolsCoreTestPlugin;

public class KeystoreTest
extends TestCase {
    private Keystore keystore = null;
    private Keystore tempKeystore = null;
    private static final String TEMP_KEYSTORE_PATH = "resources/temp_keystore.jks";
    private static final String KEYSTORE_PATH = "resources/sample_keystore.jks";
    private static final String KEYSTORE_PASSWORD = "sampleKeystore";
    private static final String KEY_ALIAS = "sampleKey";
    private static final String KEY_PASSWORD = "sampleKey";
    private HashMap<String, String> certificateData = new HashMap();

    public void setUp() throws Exception {
        File tempFile = new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH));
        if (tempFile.exists()) {
            KeystoreTest.assertTrue((boolean)tempFile.delete());
        }
        this.keystore = new Keystore(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(KEYSTORE_PATH), KEYSTORE_PASSWORD, "JCEKS");
        this.tempKeystore = new Keystore(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH), KEYSTORE_PASSWORD, "JCEKS");
        this.certificateData.put("CN", "dummy");
        this.certificateData.put("OU", "dummy");
        this.certificateData.put("O", "dummy");
        this.certificateData.put("L", "dummy");
        this.certificateData.put("ST", "dummy");
        this.certificateData.put("C", "dummy");
    }

    public void testKeystore() {
        KeystoreTest.assertNotNull((Object)this.keystore);
        KeystoreTest.assertNotNull((Object)this.tempKeystore);
    }

    public void testStore() {
        try {
            String keystorePath = XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH);
            File tempFile = new File(keystorePath);
            KeystoreTest.assertFalse((boolean)tempFile.exists());
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            KeystoreTest.assertTrue((boolean)tempFile.exists());
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testLoad() {
        try {
            KeystoreTest.assertNotNull((Object)this.keystore);
            KeystoreTest.assertTrue((boolean)this.keystore.load());
            Keystore temp = new Keystore(KEYSTORE_PATH, "wrong", "JCEKS");
            KeystoreTest.assertNotNull((Object)temp);
            KeystoreTest.assertFalse((boolean)temp.load());
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            KeystoreTest.assertTrue((boolean)this.tempKeystore.load());
            temp = new Keystore(TEMP_KEYSTORE_PATH, "wrong", "JCEKS");
            KeystoreTest.assertNotNull((Object)temp);
            KeystoreTest.assertFalse((boolean)temp.load());
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testGenerateCertificate() {
    }

    public void testGenerateSecretKey() {
        try {
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("AES", 128));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("AES", 192));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("AES", 256));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 64));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 128));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 192));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 256));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 320));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 384));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("Blowfish", 448));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("DES", 56));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("DESede", 112));
            KeystoreTest.assertNotNull((Object)this.tempKeystore.generateSecretKey("DESede", 168));
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testInsertSecretKey() {
        try {
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            SecretKey des = this.tempKeystore.generateSecretKey("DES", 56);
            KeystoreTest.assertTrue((boolean)this.tempKeystore.insertSecretKey("sampleKey", "sampleKey".toCharArray(), des));
            this.tempKeystore.store();
            SecretKey key = this.tempKeystore.getSecretKey("sampleKey", "sampleKey".toCharArray());
            KeystoreTest.assertNotNull((Object)key);
            KeystoreTest.assertEquals((String)"DES", (String)key.getAlgorithm());
            KeystoreTest.assertEquals((String)"RAW", (String)key.getFormat());
            key = this.tempKeystore.getSecretKey("sampleKey", "wrong".toCharArray());
            KeystoreTest.assertNull((Object)key);
            SecretKey aes = this.tempKeystore.generateSecretKey("AES", 256);
            KeystoreTest.assertTrue((boolean)this.tempKeystore.insertSecretKey("sampleKey2", "sampleKey".toCharArray(), aes));
            this.tempKeystore.store();
            key = this.tempKeystore.getSecretKey("sampleKey2", "sampleKey".toCharArray());
            KeystoreTest.assertNotNull((Object)key);
            KeystoreTest.assertEquals((String)"AES", (String)key.getAlgorithm());
            KeystoreTest.assertEquals((String)"RAW", (String)key.getFormat());
            key = this.tempKeystore.getSecretKey("sampleKey2", "wrong".toCharArray());
            KeystoreTest.assertNull((Object)key);
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testGetPrivateKey() {
        try {
            KeystoreTest.assertNotNull((Object)this.keystore);
            this.keystore.load();
            PrivateKey key = this.keystore.getPrivateKey("sampleKey", "sampleKey".toCharArray());
            KeystoreTest.assertNotNull((Object)key);
            KeystoreTest.assertEquals((String)"DSA", (String)key.getAlgorithm());
            KeystoreTest.assertEquals((String)"PKCS#8", (String)key.getFormat());
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            key = this.tempKeystore.getPrivateKey("sampleKey", "sampleKey".toCharArray());
            KeystoreTest.assertNull((Object)key);
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testContainsKey() {
        try {
            KeystoreTest.assertNotNull((Object)this.keystore);
            this.keystore.load();
            KeystoreTest.assertTrue((boolean)this.keystore.containsKey("sampleKey"));
            KeystoreTest.assertFalse((boolean)this.keystore.containsKey("wrong"));
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            KeystoreTest.assertFalse((boolean)this.tempKeystore.containsKey("sampleKey"));
            KeystoreTest.assertFalse((boolean)this.tempKeystore.containsKey("wrong"));
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }

    public void testGetCertificate() {
        try {
            KeystoreTest.assertNotNull((Object)this.keystore);
            this.keystore.load();
            KeystoreTest.assertNotNull((Object)this.keystore.getCertificate("sampleKey"));
            KeystoreTest.assertNull((Object)this.keystore.getCertificate("wrong"));
            KeystoreTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            KeystoreTest.assertNull((Object)this.tempKeystore.getCertificate("sampleKey"));
            KeystoreTest.assertNull((Object)this.tempKeystore.getCertificate("wrong"));
        }
        catch (Exception ex) {
            KeystoreTest.fail((String)ex.getMessage());
        }
    }
}

