/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.tests.utils;

import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.tests.XMLSecurityToolsCoreTestPlugin;

public class CertificateTest
extends TestCase {
    private Keystore tempKeystore = null;
    private static final String TEMP_KEYSTORE_PATH = "resources/temp_keystore.jks";
    private static final String KEYSTORE_PASSWORD = "sampleKeystore";

    public void setUp() throws Exception {
        File tempFile = new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH));
        if (tempFile.exists()) {
            CertificateTest.assertTrue((boolean)tempFile.delete());
        }
        this.tempKeystore = new Keystore(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH), KEYSTORE_PASSWORD, "JCEKS");
    }

    public void testGenerateCertificate() {
        try {
            HashMap<String, String> certificateData = new HashMap<String, String>();
            certificateData.put("keyalg", "DSA");
            certificateData.put("alias", "dos");
            certificateData.put("CN", "dos");
            certificateData.put("keypass", "unitTest");
            certificateData.put("keystore", "dos.jks");
            certificateData.put("storepass", "unitTest");
            File tempFile = new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(TEMP_KEYSTORE_PATH));
            CertificateTest.assertFalse((boolean)tempFile.exists());
            CertificateTest.assertNotNull((Object)this.tempKeystore);
            this.tempKeystore.store();
            CertificateTest.assertTrue((boolean)tempFile.exists());
        }
        catch (Exception exception) {
            CertificateTest.fail((String)"Keystore does not exist");
        }
    }
}

