/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.cryptography;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.security.core.XmlSecurityPlugin;

public class Keystore {
    private String file = "";
    private char[] password = null;
    private KeyStore keystore = null;

    public Keystore(String file, String password, String type) throws Exception {
        this.file = file;
        this.password = password.toCharArray();
        this.keystore = KeyStore.getInstance(type);
        this.keystore.load(null, this.password);
    }

    public void store() throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            this.keystore.store(fos, this.password);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public boolean load() throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            this.keystore.load(fis, this.password);
            return true;
        }
        catch (IOException ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to load the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public boolean insertCertificate(String alias, Certificate cert) throws Exception {
        int sizeBefore = this.keystore.size();
        if (!this.keystore.containsAlias(alias)) {
            this.keystore.setCertificateEntry(alias, cert);
            int sizeAfter = this.keystore.size();
            return sizeAfter > sizeBefore;
        }
        return false;
    }

    public SecretKey generateSecretKey(String algorithm, int size) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(algorithm);
        kg.init(size);
        return kg.generateKey();
    }

    public boolean insertSecretKey(String alias, char[] password, SecretKey key) {
        try {
            if (!this.keystore.containsAlias(alias)) {
                int sizeBefore = this.keystore.size();
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(key);
                this.keystore.setEntry(alias, skEntry, new KeyStore.PasswordProtection(password));
                int sizeAfter = this.keystore.size();
                return sizeAfter > sizeBefore;
            }
            return false;
        }
        catch (KeyStoreException ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to insert the private key into the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public SecretKey getSecretKey(String alias, char[] password) {
        try {
            if (this.keystore.containsAlias(alias)) {
                KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)this.keystore.getEntry(alias, new KeyStore.PasswordProtection(password));
                return ske.getSecretKey();
            }
            return null;
        }
        catch (Exception ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to retrieve the secret key from the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public KeyPair generateKeyPair(String algorithm, int size) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        kpg.initialize(size);
        return kpg.generateKeyPair();
    }

    public boolean insertPrivateKey(String alias, char[] password, PrivateKey key, Certificate[] chain) {
        try {
            if (!this.keystore.containsAlias(alias)) {
                int sizeBefore = this.keystore.size();
                KeyStore.PrivateKeyEntry pkEntry = new KeyStore.PrivateKeyEntry(key, chain);
                this.keystore.setEntry(alias, pkEntry, new KeyStore.PasswordProtection(password));
                int sizeAfter = this.keystore.size();
                return sizeAfter > sizeBefore;
            }
            return false;
        }
        catch (KeyStoreException ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to insert the private key into the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public PrivateKey getPrivateKey(String alias, char[] password) {
        try {
            if (this.keystore.containsAlias(alias)) {
                KeyStore.PrivateKeyEntry ske = (KeyStore.PrivateKeyEntry)this.keystore.getEntry(alias, new KeyStore.PasswordProtection(password));
                return ske.getPrivateKey();
            }
            return null;
        }
        catch (Exception ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to retrieve the private key", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public boolean containsKey(String alias) {
        try {
            return this.keystore.containsAlias(alias);
        }
        catch (KeyStoreException ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to retrieve the private key from the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    public Certificate getCertificate(String alias) {
        try {
            if (this.keystore.containsAlias(alias)) {
                return this.keystore.getCertificate(alias);
            }
            return null;
        }
        catch (KeyStoreException ex) {
            Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, "Failed to retrieve the certificate from the keystore", (Throwable)ex);
            XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

