/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.decrypt;

import java.io.File;
import java.net.URL;
import java.security.Key;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.decrypt.Decryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateDecryption {
    private File xmlDocument = null;
    private String keyFile = null;
    private String encryptionId = null;
    private String keystorePassword = "";
    private String keyName = "";
    private char[] keyPassword = null;

    public Document decrypt(Decryption decryption, IProgressMonitor monitor) throws Exception {
        URL url;
        File detachedFile;
        Node reference;
        Node uri;
        String detachedDocument;
        this.loadSettings(decryption);
        Document doc = Utils.parse(this.xmlDocument);
        monitor.worked(1);
        NodeList encryptedElements = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        int position = 0;
        monitor.worked(1);
        if (this.encryptionId != null && !this.encryptionId.equals("Use first encryption")) {
            int i = 0;
            int length = encryptedElements.getLength();
            while (i < length) {
                Element current = (Element)encryptedElements.item(i);
                String id = current.getAttribute("Id");
                if (id != null && id.equals(this.encryptionId)) {
                    position = i;
                    break;
                }
                ++i;
            }
        }
        monitor.worked(1);
        Element encryptedElement = (Element)encryptedElements.item(position);
        if (encryptedElement == null) {
            throw new Exception("No XML element EncryptedData was found in the selected XML document");
        }
        monitor.worked(1);
        SecretKey secretKey = this.getPrivateKey();
        if (secretKey == null) {
            throw new Exception("Key " + this.keyName + " not found in keystore " + this.keyFile);
        }
        monitor.worked(1);
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, (Key)secretKey);
        boolean envelopingEncryption = true;
        NodeList references = encryptedElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        if (references.getLength() > 0) {
            envelopingEncryption = false;
        }
        monitor.worked(1);
        if (envelopingEncryption) {
            xmlCipher.doFinal(doc, encryptedElement);
        } else if (references.getLength() == 1 && !(detachedDocument = (uri = (reference = references.item(0)).getAttributes().getNamedItem("URI")).getNodeValue()).equals("") && (detachedFile = new File((url = new URL(detachedDocument)).getFile())).exists()) {
            Document detachedDoc = Utils.parse(detachedFile);
            EncryptedData ed = xmlCipher.loadEncryptedData(detachedDoc, detachedDoc.getDocumentElement());
            encryptedElement = xmlCipher.martial(doc, ed);
            xmlCipher.doFinal(doc, encryptedElement);
        }
        monitor.worked(1);
        return doc;
    }

    private void loadSettings(Decryption decryption) throws Exception {
        this.xmlDocument = new File(decryption.getFile());
        this.keyFile = decryption.getKeystore();
        this.encryptionId = decryption.getEncryptionId();
        this.keystorePassword = decryption.getKeystorePassword();
        this.keyName = decryption.getKeyName();
        this.keyPassword = decryption.getKeyPassword();
    }

    private SecretKey getPrivateKey() throws Exception {
        Keystore keystore = new Keystore(this.keyFile, this.keystorePassword, "JCEKS");
        keystore.load();
        return keystore.getSecretKey(this.keyName, this.keyPassword);
    }
}

