/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.sign;

import java.io.File;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignatureProperties;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.DigitalSignatureProperty;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.SignatureNamespaceContext;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.core.utils.XmlSecurityConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateSignature {
    private XMLSignature sig = null;
    private File xmlFile = null;
    private File detachedFile = null;
    private String baseURI = null;
    private String resource = null;
    private String expression = null;
    private String signatureType = null;
    private Keystore keystore = null;
    private char[] keyPassword = null;
    private String keyName = null;
    private String signatureId = null;
    private String messageDigestAlgorithm = null;
    private String signatureAlgorithm = null;
    private String canonicalizationAlgorithm = null;
    private String transformationAlgorithm = null;
    private String textSelection = null;
    private ArrayList<DigitalSignatureProperty> properties = null;

    public Document sign(Signature model, String selection, IProgressMonitor monitor) throws Exception {
        Document signedDoc = null;
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.loadSettings(model, selection);
            monitor.worked(1);
            this.keystore.load();
            monitor.worked(1);
            PrivateKey privateKey = this.keystore.getPrivateKey(this.keyName, this.keyPassword);
            monitor.worked(1);
            Document doc = Utils.parse(this.xmlFile);
            ResolverFragment fragmentResolver = new ResolverFragment();
            this.sig = new XMLSignature(doc, this.baseURI, this.signatureAlgorithm, this.canonicalizationAlgorithm);
            this.sig.addResourceResolver((ResourceResolverSpi)fragmentResolver);
            monitor.worked(1);
            if ("enveloping".equalsIgnoreCase(this.signatureType)) {
                signedDoc = this.createEnvelopingSignature(privateKey, doc);
            } else if ("enveloped".equalsIgnoreCase(this.signatureType)) {
                signedDoc = this.createEnvelopedSignature(privateKey, doc);
            } else if ("detached".equalsIgnoreCase(this.signatureType)) {
                signedDoc = this.createDetachedSignature(privateKey, doc);
            }
        }
        finally {
            monitor.worked(1);
        }
        return signedDoc;
    }

    private void loadSettings(Signature signature, String selection) throws Exception {
        this.xmlFile = new File(signature.getFile());
        this.baseURI = this.xmlFile.toURI().toString();
        this.resource = signature.getResource();
        this.expression = null;
        if ("xpath".equalsIgnoreCase(this.resource)) {
            this.expression = signature.getXpath();
        } else if ("selection".equalsIgnoreCase(this.resource)) {
            this.textSelection = selection;
        }
        this.signatureType = signature.getSignatureType();
        if ("detached".equalsIgnoreCase(this.signatureType)) {
            this.detachedFile = signature.getDetachedFile();
        }
        this.keystore = signature.getKeystore();
        this.keyPassword = signature.getKeyPassword();
        this.keyName = signature.getKeyName();
        if (signature.getSignatureProperties() != null) {
            this.properties = signature.getSignatureProperties();
        }
        if (signature.getSignatureId() != null) {
            this.signatureId = signature.getSignatureId();
        }
        this.messageDigestAlgorithm = XmlSecurityConstants.getMessageDigestAlgorithm(signature.getMessageDigestAlgorithm());
        this.signatureAlgorithm = XmlSecurityConstants.getSignatureAlgorithm(signature.getSignatureAlgorithm());
        this.canonicalizationAlgorithm = XmlSecurityConstants.getCanonicalizationAlgorithm(signature.getCanonicalizationAlgorithm());
        this.transformationAlgorithm = XmlSecurityConstants.getTransformationAlgorithm(signature.getTransformationAlgorithm());
    }

    private Document createDetachedSignature(PrivateKey privateKey, Document doc) throws Exception {
        boolean doSign;
        Element root = doc.getDocumentElement();
        Transforms transforms = null;
        root.appendChild(this.sig.getElement());
        if (this.transformationAlgorithm != null && !"None".equals(this.transformationAlgorithm)) {
            transforms = new Transforms(doc);
            transforms.addTransform(this.transformationAlgorithm);
        }
        this.sig.addDocument(this.detachedFile.toURI().toString(), transforms, this.messageDigestAlgorithm);
        this.addProperties(doc);
        if (!"".equals(this.signatureId)) {
            this.sig.setId(this.signatureId);
        }
        if (doSign = this.addCertificate()) {
            this.sig.sign((Key)privateKey);
        }
        return doc;
    }

    private Document createEnvelopedSignature(PrivateKey privateKey, Document doc) throws Exception {
        boolean doSign;
        Transforms transforms;
        Element root = doc.getDocumentElement();
        if ("document".equalsIgnoreCase(this.resource)) {
            transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            if (this.transformationAlgorithm != null && !"None".equals(this.transformationAlgorithm)) {
                transforms.addTransform(this.transformationAlgorithm);
            }
            this.sig.addDocument("", transforms, this.messageDigestAlgorithm);
        } else if ("selection".equalsIgnoreCase(this.resource)) {
            Document selectionDoc = Utils.parse(this.textSelection);
            String finalXpath = Utils.getUniqueXPathToNode(doc, selectionDoc);
            Transforms transforms2 = new Transforms(doc);
            transforms2.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms2.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceIntersect((Document)doc, (String)finalXpath).getElement());
            if (this.transformationAlgorithm != null && !"None".equals(this.transformationAlgorithm)) {
                transforms2.addTransform(this.transformationAlgorithm);
            }
            this.sig.addDocument("", transforms2, this.messageDigestAlgorithm);
        } else if ("xpath".equalsIgnoreCase(this.resource)) {
            transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstanceIntersect((Document)doc, (String)this.expression).getElement());
            if (this.transformationAlgorithm != null && !"None".equals(this.transformationAlgorithm)) {
                transforms.addTransform(this.transformationAlgorithm);
            }
            this.sig.addDocument("", transforms, this.messageDigestAlgorithm);
        }
        root.appendChild(this.sig.getElement());
        this.addProperties(doc);
        if (!"".equals(this.signatureId)) {
            this.sig.setId(this.signatureId);
        }
        if (doSign = this.addCertificate()) {
            this.sig.sign((Key)privateKey);
        }
        return doc;
    }

    private Document createEnvelopingSignature(PrivateKey privateKey, Document doc) throws Exception {
        boolean doSign;
        Element root = doc.getDocumentElement();
        ObjectContainer obj = new ObjectContainer(doc);
        String objectId = root.getLocalName();
        if ("document".equalsIgnoreCase(this.resource)) {
            obj.appendChild((Node)root);
            obj.setId(objectId);
            doc.appendChild(this.sig.getElement());
        } else if ("selection".equalsIgnoreCase(this.resource)) {
            Document selectionDoc = Utils.parse(this.textSelection);
            String expression = Utils.getUniqueXPathToNode(doc, selectionDoc);
            XPath xpath = XPathFactory.newInstance().newXPath();
            SignatureNamespaceContext ns = new SignatureNamespaceContext();
            xpath.setNamespaceContext(ns);
            Element selectedElement = (Element)xpath.evaluate(expression, doc, XPathConstants.NODE);
            objectId = selectedElement.getLocalName();
            obj.appendChild((Node)selectedElement);
            obj.setId(objectId);
            if (!root.isSameNode(selectedElement)) {
                root.appendChild(this.sig.getElement());
            } else {
                doc.appendChild(this.sig.getElement());
            }
        } else if ("xpath".equalsIgnoreCase(this.resource)) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            SignatureNamespaceContext ns = new SignatureNamespaceContext();
            xpath.setNamespaceContext(ns);
            Element selectedElement = (Element)xpath.evaluate(this.expression, doc, XPathConstants.NODE);
            objectId = selectedElement.getLocalName();
            obj.appendChild((Node)selectedElement);
            obj.setId(objectId);
            if (!root.isSameNode(selectedElement)) {
                root.appendChild(this.sig.getElement());
            } else {
                doc.appendChild(this.sig.getElement());
            }
        }
        this.sig.appendObject(obj);
        Transforms transforms = null;
        if (this.transformationAlgorithm != null && !"None".equals(this.transformationAlgorithm)) {
            transforms = new Transforms(doc);
            transforms.addTransform(this.transformationAlgorithm);
        }
        this.sig.addDocument("#" + objectId, transforms, this.messageDigestAlgorithm);
        this.addProperties(doc);
        if (!"".equals(this.signatureId)) {
            this.sig.setId(this.signatureId);
        }
        if (doSign = this.addCertificate()) {
            this.sig.sign((Key)privateKey);
        }
        return doc;
    }

    private void addProperties(Document doc) throws Exception {
        if (this.properties != null && this.properties.size() > 0) {
            SignatureProperties props = new SignatureProperties(doc);
            int i = 0;
            int size = this.properties.size();
            while (i < size) {
                if (!"".equals(this.properties.get(i).getId()) && !"".equals(this.properties.get(i).getTarget())) {
                    SignatureProperty prop = new SignatureProperty(doc, this.properties.get(i).getTarget(), this.properties.get(i).getId());
                    prop.getElement().appendChild(doc.createTextNode("\n " + this.properties.get(i).getContent() + "\n"));
                    props.addSignatureProperty(prop);
                    this.sig.addDocument("#" + this.properties.get(i).getId());
                }
                ++i;
            }
            ObjectContainer object = new ObjectContainer(doc);
            object.appendChild((Node)doc.createTextNode("\n"));
            object.appendChild((Node)props.getElement());
            object.appendChild((Node)doc.createTextNode("\n"));
            this.sig.appendObject(object);
        }
    }

    private boolean addCertificate() throws Exception {
        boolean addedCertificate = false;
        X509Certificate cert = (X509Certificate)this.keystore.getCertificate(this.keyName);
        if (cert != null) {
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                addedCertificate = false;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                addedCertificate = false;
            }
            this.sig.addKeyInfo(cert);
            this.sig.addKeyInfo(cert.getPublicKey());
            addedCertificate = true;
        }
        return addedCertificate;
    }
}

