/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.tests.verify;

import junit.framework.TestCase;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.ui.verify.SignatureLabelProvider;
import org.eclipse.wst.xml.security.ui.verify.SignatureView;

public class SignatureViewTest
extends TestCase {
    private static final String VIEW_ID = "org.eclipse.wst.xml.security.ui.SignatureView";
    private SignatureView testView;

    protected void setUp() throws Exception {
        this.waitForJobs();
        this.testView = (SignatureView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(VIEW_ID);
        this.waitForJobs();
        this.delay(3000);
    }

    protected void tearDown() throws Exception {
        this.waitForJobs();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.testView);
    }

    public void testView() {
        TableViewer viewer = this.testView.getSignaturesViewer();
        SignatureViewTest.assertNotNull((Object)viewer);
        ArrayContentProvider contentProvider = (ArrayContentProvider)viewer.getContentProvider();
        SignatureViewTest.assertNotNull((Object)contentProvider);
        SignatureLabelProvider labelProvider = (SignatureLabelProvider)viewer.getLabelProvider();
        SignatureViewTest.assertNotNull((Object)labelProvider);
        SignatureViewTest.assertEquals((int)4, (int)viewer.getTable().getColumnCount());
        SignatureViewTest.assertEquals((String)"0 Signatures: 0 valid, 0 invalid, 0 unknown", (String)this.testView.getContentDescription());
    }

    private void waitForJobs() {
        while (!Job.getJobManager().isIdle()) {
            this.delay(1000);
        }
    }

    private void delay(int waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + (long)waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

