/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.verify.VerifyDocument;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.verify.SignatureView;

public class VerifyNewAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private static final String ERROR_TEXT = "An error occured during verification";
    private static final String ACTION = "verify";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.doVerification();
    }

    private void doVerification() {
        VerifyDocument verify = new VerifyDocument();
        ArrayList results = new ArrayList();
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        if (workbenchPart != null && workbenchPart instanceof ITextEditor) {
            this.editor = (ITextEditor)workbenchPart;
            if (this.editor.isDirty()) {
                this.saveEditorContent(this.editor);
            }
            this.file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        } else {
            this.editor = null;
        }
        try {
            IWorkbenchPage page;
            IViewPart vp;
            if (this.file != null && this.file.isAccessible()) {
                results = verify.verify(this.file.getLocation().toString());
            } else {
                this.showInfo(Messages.verificationImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
            if (results.size() == 0) {
                this.showInfo(Messages.signaturesView, Messages.noSignaturesInDocument);
            }
            if ((vp = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).showView("org.eclipse.wst.xml.security.ui.SignatureView")) instanceof SignatureView) {
                ((SignatureView)vp).setInput(results);
            }
        }
        catch (XMLSignatureException xmlse) {
            this.showError(Messages.error, String.valueOf(Messages.invalidValueElement) + xmlse.getLocalizedMessage());
        }
        catch (KeyResolverException kre) {
            this.showError(Messages.error, String.valueOf(Messages.invalidCertificate) + kre.getLocalizedMessage());
        }
        catch (Exception ex) {
            this.showErrorDialog(Messages.error, Messages.verificationError, ex);
            this.log(ERROR_TEXT, ex);
        }
    }
}

