/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.canonicalize.Canonicalization;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;

public class CanonicalizeAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private String canonVersion;
    private String canonType;
    private String canonTarget;
    private static final String ACTION = "canonicalize";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.canonType = action.getId();
        this.createCanonicalization();
    }

    private void createCanonicalization() {
        try {
            this.getPreferenceValues();
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
            if (this.editor != null && this.editor.isEditable()) {
                if (this.editor.isDirty()) {
                    this.saveEditorContent(this.editor);
                }
                IEditorInput input = this.editor.getEditorInput();
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
                this.file = (IFile)input.getAdapter(IFile.class);
                if (this.file != null) {
                    byte[] outputBytes = this.canonicalize(this.file.getContents());
                    if (this.canonTarget.equals("internal")) {
                        document.set(new String(outputBytes, "UTF8"));
                    } else {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (page != null) {
                            IFile newFile = this.saveCanonicalizedFile(this.getCanonicalizedPath(), outputBytes);
                            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(newFile.getName());
                            page.openEditor((IEditorInput)new FileEditorInput(newFile), desc.getId());
                        }
                    }
                } else {
                    this.showInfo(Messages.canonicalizationImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
                }
            } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
                byte[] outputBytes = this.canonicalize(this.file.getContents());
                if (this.canonTarget.equals("internal")) {
                    this.saveCanonicalizedFile(this.file.getLocation(), outputBytes);
                } else {
                    this.saveCanonicalizedFile(this.getCanonicalizedPath(), outputBytes);
                }
            } else {
                this.showInfo(Messages.canonicalizationImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        }
        catch (Exception ex) {
            this.showErrorDialog(Messages.error, Messages.canonicalizationException, ex);
            this.log("An error occured during canonicalization", ex);
        }
    }

    private IPath getCanonicalizedPath() {
        IPath path = this.file.getLocation().removeFileExtension();
        String filename = path.lastSegment();
        path = path.removeLastSegments(1);
        if (filename.endsWith("_canon")) {
            filename = String.valueOf(filename) + "[2].xml";
        } else if (filename.contains("_canon[")) {
            int canonNumber = Integer.parseInt(filename.substring(filename.indexOf("[") + 1, filename.indexOf("]")));
            filename = String.valueOf(filename.substring(0, filename.indexOf("[") + 1)) + (canonNumber + 1) + "].xml";
        } else {
            filename = String.valueOf(filename) + "_canon.xml";
        }
        path = path.append(filename);
        return path;
    }

    private IFile saveCanonicalizedFile(IPath newFilePath, byte[] outputBytes) throws Exception {
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(newFilePath);
        if (newFile.exists()) {
            newFile.setContents((InputStream)new ByteArrayInputStream(outputBytes), true, true, null);
        } else {
            newFile.create((InputStream)new ByteArrayInputStream(outputBytes), true, null);
        }
        return newFile;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.canonVersion = store.getString("canonType");
        this.canonTarget = store.getString("canonTarget");
    }

    private byte[] canonicalize(InputStream stream) throws Exception {
        Canonicalization canonicalization = new Canonicalization();
        byte[] outputBytes = canonicalization.canonicalize(stream, this.getCanonicalizationAlgorithm());
        return outputBytes;
    }

    private String getCanonicalizationAlgorithm() {
        String algorithm = "";
        algorithm = this.canonType.equals("org.eclipse.wst.xml.security.core.actions.CanonicalizationRemoveComments") ? (this.canonVersion.equals("exclusive") ? "http://www.w3.org/2001/10/xml-exc-c14n#" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315") : (this.canonVersion.equals("exclusive") ? "http://www.w3.org/2001/10/xml-exc-c14n#WithComments" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        return algorithm;
    }
}

