/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.decrypt.CreateDecryption;
import org.eclipse.wst.xml.security.core.decrypt.Decryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DecryptQuickAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private String keystore;
    private String keystorePassword;
    private String keyName;
    private char[] keyPassword;
    private String encryptionID;
    private boolean completePrefs = false;
    private static final String ERROR_TEXT = "An error occured during quick decryption";
    private static final String ACTION = "decrypt";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            PasswordDialog keystorePasswordDialog = new PasswordDialog(this.getShell(), Messages.keystorePassword, Messages.enterKeystorePassword, "");
            if (keystorePasswordDialog.open() != 0) {
                return;
            }
            this.keystorePassword = keystorePasswordDialog.getValue();
            PasswordDialog keyPasswordDialog = new PasswordDialog(this.getShell(), Messages.keyPassword, Messages.enterKeyPassword, "");
            if (keyPasswordDialog.open() != 0) {
                return;
            }
            this.keyPassword = keyPasswordDialog.getValue().toCharArray();
            try {
                this.quickDecrypt();
            }
            catch (Exception ex) {
                this.showErrorDialog(Messages.error, Messages.decryptingError, ex);
                this.log(ERROR_TEXT, ex);
            }
        }
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.keystore = store.getString("encryptionKeyStore");
        this.keyName = store.getString("encryptionKeyName");
        this.encryptionID = store.getString("encryptionID");
    }

    private void quickDecrypt() throws Exception {
        final Decryption wizard = new Decryption();
        wizard.setKeystore(this.keystore);
        wizard.setKeystorePassword(this.keystorePassword);
        wizard.setKeyName(this.keyName);
        wizard.setKeyPassword(this.keyPassword);
        wizard.setEncryptionId(this.encryptionID);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
        if (this.editor != null && this.editor.isEditable()) {
            if (this.editor.isDirty()) {
                this.saveEditorContent(this.editor);
            }
            IEditorInput input = this.editor.getEditorInput();
            final IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
            this.file = (IFile)input.getAdapter(IFile.class);
            if (this.file != null) {
                wizard.setFile(this.file.getLocation().toString());
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.decryptionTaskInfo, 6);
                                CreateDecryption decryption = new CreateDecryption();
                                Document doc = decryption.decrypt(wizard, monitor);
                                if (doc != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                }
                            }
                            catch (Exception ex) {
                                DecryptQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        DecryptQuickAction.this.showErrorDialog(Messages.error, Messages.decryptingError, ex);
                                        DecryptQuickAction.this.log(DecryptQuickAction.ERROR_TEXT, ex);
                                    }
                                });
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            } else {
                this.showInfo(Messages.quickDecryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
            final String filename = this.file.getLocation().toString();
            wizard.setFile(this.file.getLocation().toString());
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    OutputStream fos = null;
                    try {
                        try {
                            monitor.beginTask(Messages.decryptionTaskInfo, 6);
                            CreateDecryption decryption = new CreateDecryption();
                            Document doc = decryption.decrypt(wizard, monitor);
                            fos = new FileOutputStream(filename);
                            if (doc != null) {
                                XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                            }
                        }
                        catch (Exception ex) {
                            DecryptQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    DecryptQuickAction.this.showErrorDialog(Messages.error, Messages.decryptingError, ex);
                                    DecryptQuickAction.this.log(DecryptQuickAction.ERROR_TEXT, ex);
                                }
                            });
                            if (fos != null) {
                                try {
                                    fos.flush();
                                    ((FileOutputStream)fos).close();
                                }
                                catch (IOException ex2) {
                                    DecryptQuickAction.this.log(DecryptQuickAction.ERROR_TEXT, ex2);
                                }
                            }
                            monitor.done();
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.flush();
                                ((FileOutputStream)fos).close();
                            }
                            catch (IOException ex) {
                                DecryptQuickAction.this.log(DecryptQuickAction.ERROR_TEXT, ex);
                            }
                        }
                        monitor.done();
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException ite) {
                this.log(ERROR_TEXT, ite);
            }
            catch (InterruptedException ie) {
                this.log(ERROR_TEXT, ie);
            }
        } else {
            this.showInfo(Messages.quickDecryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
        }
    }

    private boolean checkPreferences() {
        String title = Messages.quickDecryptionTitle;
        int result = 2;
        if (this.keystore == null || this.keystore.equals("")) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingKeystore), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.keyName == null || this.keyName.equals("")) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingKeyName), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }
}

