/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.encrypt.CreateEncryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.SignNewAction;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.encrypt.NewEncryptionWizard;
import org.w3c.dom.Document;

public class EncryptNewAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private ITextSelection textSelection = null;
    private static final String ERROR_TEXT = "An error occured during encryption";
    private static final String ACTION = "encrypt";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.createEncryption();
    }

    private void createEncryption() {
        try {
            NewEncryptionWizard encWizard = new NewEncryptionWizard();
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
            if (this.editor != null && this.editor.isEditable()) {
                if (this.editor.isDirty()) {
                    this.saveEditorContent(this.editor);
                }
                IEditorInput input = this.editor.getEditorInput();
                this.file = (IFile)input.getAdapter(IFile.class);
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
                this.textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
                boolean validSelection = this.parseSelection(this.textSelection.getText());
                if (this.file != null) {
                    if (validSelection) {
                        encWizard.init(this.file, this.textSelection);
                    } else {
                        encWizard.init(this.file);
                    }
                    CreateEncryption encryption = new CreateEncryption();
                    this.encryptData(encryption, encWizard, document, "");
                    if (encWizard.getModel().getLaunchSignatureWizard()) {
                        this.launchXMLSignatureWizard();
                    }
                } else {
                    this.showInfo(Messages.encryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
                }
            } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
                encWizard.init(this.file);
                CreateEncryption encryption = new CreateEncryption();
                this.encryptData(encryption, encWizard, null, this.file.getLocation().toString());
                if (encWizard.getModel().getLaunchSignatureWizard()) {
                    this.launchXMLSignatureWizard();
                }
            } else {
                this.showInfo(Messages.encryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        }
        catch (Exception ex) {
            this.showErrorDialog(Messages.error, Messages.encryptingError, ex);
            this.log(ERROR_TEXT, ex);
        }
    }

    private void encryptData(final CreateEncryption data, final NewEncryptionWizard wizard, final IDocument document, final String filename) throws Exception {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job("XML Encryption"){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.encryptionTaskInfo, 3);
                            Document doc = null;
                            doc = EncryptNewAction.this.textSelection != null ? data.encrypt(wizard.getModel(), EncryptNewAction.this.textSelection.getText(), monitor) : data.encrypt(wizard.getModel(), null, monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)true));
                                    break block8;
                                }
                                FileWriter fw = new FileWriter(filename);
                                fw.write(Utils.docToString((Document)doc, (boolean)true));
                                fw.flush();
                                fw.close();
                            }
                            catch (Exception ex) {
                                EncryptNewAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        EncryptNewAction.this.showErrorDialog(Messages.error, Messages.encryptingError, ex);
                                        EncryptNewAction.this.log(EncryptNewAction.ERROR_TEXT, ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }

    private void launchXMLSignatureWizard() {
        SignNewAction sign = new SignNewAction();
        sign.signAfterEncryption(this.file);
    }

    public void encryptAfterSignature(IFile signedFile) {
        this.file = signedFile;
        this.createEncryption();
    }
}

