/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.CreateSignature;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class SignQuickAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private String resource;
    private String xpath = "";
    private String signatureType;
    private Keystore keystore;
    private String keyFile;
    private char[] keystorePassword;
    private String keyName;
    private char[] keyPassword;
    private String canonicalizationAlgorithm;
    private String transformationAlgorithm;
    private String messageDigestAlgorithm;
    private String signatureAlgorithm;
    private String signatureId;
    private boolean completePrefs = false;
    private static final String ERROR_TEXT = "An error occured during quick signing";
    private static final String ACTION = "sign";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            PasswordDialog keystorePasswordDialog = new PasswordDialog(this.getShell(), Messages.keystorePassword, Messages.enterKeystorePassword, "");
            if (keystorePasswordDialog.open() != 0) {
                return;
            }
            this.keystorePassword = keystorePasswordDialog.getValue().toCharArray();
            PasswordDialog privateKeyPasswordDialog = new PasswordDialog(this.getShell(), Messages.keyPassword, Messages.enterKeyPassword, "");
            if (privateKeyPasswordDialog.open() != 0) {
                return;
            }
            this.keyPassword = privateKeyPasswordDialog.getValue().toCharArray();
            if (this.checkPasswords()) {
                try {
                    if (this.loadKeystore()) {
                        this.quickSign();
                    } else {
                        this.showError(Messages.error, Messages.failedLoadingKeystore);
                    }
                }
                catch (SAXParseException spe) {
                    this.showError(Messages.parsingError, String.valueOf(Messages.parsingErrorText) + spe.getLocalizedMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showError(Messages.keystore, Messages.keystoreNotFound);
                }
                catch (IOException ioe) {
                    this.showError(Messages.keystore, String.valueOf(Messages.keystoreError) + ioe.getLocalizedMessage());
                }
                catch (Exception ex) {
                    this.showErrorDialog(Messages.error, Messages.signingError, ex);
                    this.log(ERROR_TEXT, ex);
                }
            }
        }
    }

    private boolean loadKeystore() throws Exception {
        block3: {
            try {
                this.keystore = new Keystore(this.keyFile, this.keystorePassword.toString(), "JCEKS");
                this.keystore.load();
                if (this.keystore.containsKey(this.keyName)) break block3;
                return false;
            }
            catch (Exception ex) {
                this.log(ERROR_TEXT, ex);
                return false;
            }
        }
        return this.keystore.getPrivateKey(this.keyName, this.keyPassword) != null;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.resource = store.getString("signatureResource");
        if (this.resource != null && this.resource.equals("xpath")) {
            this.xpath = store.getString("signatureXPath");
        }
        this.signatureType = store.getString("signatureType");
        this.keyFile = store.getString("signatureKeystoreFile");
        this.keyName = store.getString("signatureKeyName");
        this.canonicalizationAlgorithm = store.getString("signatureCanonicalization");
        this.transformationAlgorithm = store.getString("signatureTransformation");
        this.messageDigestAlgorithm = store.getString("signatureMDA");
        this.signatureAlgorithm = store.getString("signatureAlgorithm");
        this.signatureId = store.getString("signatureID");
    }

    private void quickSign() throws Exception {
        final Signature signatureWizard = new Signature();
        signatureWizard.setResource(this.resource);
        signatureWizard.setXpath(this.xpath);
        signatureWizard.setSignatureType(this.signatureType);
        signatureWizard.setBsp(false);
        signatureWizard.setKeystore(this.keystore);
        signatureWizard.setKeyName(this.keyName);
        signatureWizard.setKeystorePassword(this.keystorePassword);
        signatureWizard.setKeyPassword(this.keyPassword);
        signatureWizard.setCanonicalizationAlgorithm(this.canonicalizationAlgorithm);
        signatureWizard.setTransformationAlgorithm(this.transformationAlgorithm);
        signatureWizard.setMessageDigestAlgorithm(this.messageDigestAlgorithm);
        signatureWizard.setSignatureAlgorithm(this.signatureAlgorithm);
        signatureWizard.setSignatureId(this.signatureId);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
        if (this.editor != null && this.editor.isEditable()) {
            boolean validSelection = false;
            if (this.editor.isDirty()) {
                this.saveEditorContent(this.editor);
            }
            IEditorInput input = this.editor.getEditorInput();
            final IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
            this.file = (IFile)input.getAdapter(IFile.class);
            final ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
            if ("selection".equals(this.resource) && textSelection != null && !textSelection.isEmpty() && textSelection.getLength() > 0 && this.file != null) {
                validSelection = this.parseSelection(textSelection.getText());
            }
            if (this.file != null && validSelection) {
                signatureWizard.setFile(this.file.getLocation().toString());
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.signatureTaskInfo, 5);
                                CreateSignature content = new CreateSignature();
                                Document doc = content.sign(signatureWizard, textSelection.getText(), monitor);
                                if (doc != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                }
                            }
                            catch (Exception ex) {
                                SignQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        SignQuickAction.this.showErrorDialog(Messages.error, Messages.signingError, ex);
                                        SignQuickAction.this.log(SignQuickAction.ERROR_TEXT, ex);
                                    }
                                });
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            } else if (this.file != null && !"selection".equals(this.resource)) {
                signatureWizard.setFile(this.file.getLocation().toString());
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.signatureTaskInfo, 5);
                                CreateSignature content = new CreateSignature();
                                Document doc = content.sign(signatureWizard, null, monitor);
                                if (doc != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                }
                            }
                            catch (Exception ex) {
                                SignQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        SignQuickAction.this.showErrorDialog(Messages.error, Messages.signingError, ex);
                                        SignQuickAction.this.log(SignQuickAction.ERROR_TEXT, ex);
                                    }
                                });
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            } else if ("selection".equals(this.resource) && !validSelection) {
                this.showInfo(Messages.invalidTextSelection, Messages.invalidTextSelectionText);
            } else {
                this.showInfo(Messages.quickSignatureImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
            if ("selection".equals(this.resource)) {
                this.showInfo(Messages.quickSignatureImpossible, Messages.quickSignatureImpossibleText);
            } else {
                final String filename = this.file.getLocation().toString();
                signatureWizard.setFile(this.file.getLocation().toString());
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            try {
                                monitor.beginTask(Messages.signatureTaskInfo, 5);
                                CreateSignature content = new CreateSignature();
                                Document doc = content.sign(signatureWizard, null, monitor);
                                FileOutputStream fos = new FileOutputStream(filename);
                                if (doc != null) {
                                    XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                                }
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex) {
                                SignQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        SignQuickAction.this.showErrorDialog(Messages.error, Messages.signingError, ex);
                                        SignQuickAction.this.log(SignQuickAction.ERROR_TEXT, ex);
                                    }
                                });
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            }
        } else {
            this.showInfo(Messages.quickSignatureImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
        }
    }

    private boolean checkPreferences() {
        String title = Messages.quickSignatureTitle;
        int result = 2;
        if (this.resource == null || "".equals(this.resource)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingResource), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.resource != null && "xpath".equals(this.resource) && (this.xpath == null || "".equals(this.xpath))) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingXPathExpression), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.signatureType == null || "".equals(this.signatureType)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingSignatureType), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.keyFile == null || "".equals(this.keyFile)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingKeystoreFile), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.keyName == null || "".equals(this.keyName)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingKeyName), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.canonicalizationAlgorithm == null || "".equals(this.canonicalizationAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingCanonicalizationAlgorithm), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.transformationAlgorithm != null && "".equals(this.transformationAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingTransformationAlgorithm), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.messageDigestAlgorithm == null || "".equals(this.messageDigestAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingMDAlgorithm), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.signatureAlgorithm == null || "".equals(this.signatureAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingSignatureAlgorithm), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else if (this.signatureId == null || "".equals(this.signatureId)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingSignatureId), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }

    private boolean checkPasswords() {
        if (this.keystorePassword == null || this.keystorePassword.length == 0) {
            this.showInfo(Messages.quickSignatureTitle, Messages.missingKeystorePassword);
            return false;
        }
        if (this.keyPassword == null || this.keyPassword.length == 0) {
            this.showInfo(Messages.quickSignatureTitle, Messages.missingKeyPassword);
            return false;
        }
        return true;
    }
}

