/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.eclipse.wst.xml.security.core.verify.VerifySignature;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.verify.Verification;

public class VerifyQuickAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private String signatureId;
    private static final String ACTION = "verify";
    private boolean preferencesComplete = false;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            try {
                this.doVerification();
            }
            catch (XMLSignatureException xmlse) {
                this.showError(Messages.error, String.valueOf(Messages.invalidValueElement) + xmlse.getLocalizedMessage());
            }
            catch (KeyResolverException kre) {
                this.showError(Messages.error, String.valueOf(Messages.invalidCertificate) + kre.getLocalizedMessage());
            }
            catch (Exception e) {
                this.showError(Messages.error, String.valueOf(Messages.verificationError) + e.getLocalizedMessage());
                this.log("An error occured during quick verification", e);
            }
        }
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.signatureId = store.getString("signatureID");
    }

    private void doVerification() throws Exception {
        VerifySignature verify = new VerifySignature();
        ArrayList results = new ArrayList();
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        if (workbenchPart != null && workbenchPart instanceof ITextEditor) {
            this.editor = (ITextEditor)workbenchPart;
            if (this.editor.isDirty()) {
                this.saveEditorContent(this.editor);
            }
            this.file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        } else {
            this.editor = null;
        }
        if (this.file != null && this.file.isAccessible()) {
            results = verify.verify(this.file.getLocation().toString(), this.signatureId);
        } else {
            this.showInfo(Messages.quickVerificationImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
        }
        if (results.size() == 1) {
            VerificationResult result = (VerificationResult)results.get(0);
            if (result.getSignature() != null) {
                Verification.showVerificationResult(result, this.getShell());
            } else {
                this.showError(Messages.quickVerificationImpossible, NLS.bind((String)Messages.signatureNotFound, (Object)this.signatureId));
            }
        } else {
            this.showError(Messages.quickVerificationImpossible, NLS.bind((String)Messages.signatureNotFound, (Object)this.signatureId));
        }
    }

    private boolean checkPreferences() {
        int result = 2;
        if (this.signatureId == null || "".equals(this.signatureId)) {
            result = this.showMissingParameterDialog(Messages.quickVerificationTitle, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingSignatureId), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
        } else {
            this.preferencesComplete = true;
        }
        if (result == 0) {
            this.preferencesComplete = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.preferencesComplete;
    }
}

