/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.preferences.Messages;
import org.eclipse.wst.xml.security.ui.preferences.PreferenceValues;

public class PreferencePageSignature
extends PreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor signatureType = null;
    private FileFieldEditor keystoreFile = null;
    private Button signDocument;
    private Button signSelection;
    private Button signXPath;
    private Text signXPathText;
    private Combo algoCanonCombo;
    private Combo algoTransformCombo;
    private Combo algoMDCombo;
    private Combo algoSignCombo;
    private Text keyNameText;
    private Text signIdText;
    private Label signXPathLabel;
    private ArrayList<Button> checkBoxes = new ArrayList();
    private ArrayList<Button> radioButtons;
    private ArrayList<Text> textControls;
    private ArrayList<Combo> comboBoxes = new ArrayList();
    private SelectionListener selectionListener;
    private ModifyListener modifyListener;

    public PreferencePageSignature() {
        this.radioButtons = new ArrayList();
        this.textControls = new ArrayList();
        this.addListener();
    }

    private void addListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageSignature.this.controlChanged(e.widget);
            }
        };
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreferencePageSignature.this.controlModified(e.widget);
            }
        };
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(XSTUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.signaturePrefsDesc);
    }

    public boolean isValid() {
        return true;
    }

    public boolean okToLeave() {
        return true;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group signatureResourceGroup = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        signatureResourceGroup.setLayout((Layout)layout);
        signatureResourceGroup.setLayoutData((Object)gd);
        signatureResourceGroup.setText(Messages.resource);
        int indent = 0;
        this.signDocument = this.addRadioButton((Composite)signatureResourceGroup, Messages.document, "signatureResource", "document", indent);
        this.signDocument.addSelectionListener(this.selectionListener);
        this.signSelection = this.addRadioButton((Composite)signatureResourceGroup, Messages.selection, "signatureResource", "selection", indent);
        this.signSelection.addSelectionListener(this.selectionListener);
        this.signXPath = this.addRadioButton((Composite)signatureResourceGroup, Messages.xpath, "signatureResource", "xpath", indent);
        this.signXPath.addSelectionListener(this.selectionListener);
        indent = this.convertWidthInCharsToPixels(4);
        this.signXPathLabel = new Label((Composite)signatureResourceGroup, 0);
        this.signXPathLabel.setText(Messages.xpathExpression);
        this.signXPathLabel.setEnabled(this.signXPath.getSelection());
        this.signXPathText = this.addTextControl((Composite)signatureResourceGroup, this.signXPathLabel, "signatureXPath", indent);
        this.signXPathText.addModifyListener(this.modifyListener);
        this.signXPathText.setEnabled(this.signXPath.getSelection());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.signatureType = new RadioGroupFieldEditor("signatureType", Messages.type, 2, PreferenceValues.SIGNATURE_TYPES, top, true);
        this.signatureType.setPage((DialogPage)this);
        this.signatureType.setPreferenceStore(this.getPreferenceStore());
        this.signatureType.load();
        this.signatureType.fillIntoGrid(top, 2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group signatureAlgorithmsGroup = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        signatureAlgorithmsGroup.setLayout((Layout)layout);
        signatureAlgorithmsGroup.setLayoutData((Object)gd);
        signatureAlgorithmsGroup.setText(Messages.algorithms);
        indent = 0;
        Label algoCanonLabel = new Label((Composite)signatureAlgorithmsGroup, 0);
        algoCanonLabel.setText(Messages.signaturePrefsAlgoCanon);
        this.algoCanonCombo = this.addComboControl((Composite)signatureAlgorithmsGroup, algoCanonLabel, "signatureCanonicalization", indent, Algorithms.CANONICALIZATION_ALOGRITHMS);
        this.algoCanonCombo.addModifyListener(this.modifyListener);
        Label algoTransformLabel = new Label((Composite)signatureAlgorithmsGroup, 0);
        algoTransformLabel.setText(Messages.signaturePrefsAlgoTransform);
        this.algoTransformCombo = this.addComboControl((Composite)signatureAlgorithmsGroup, algoTransformLabel, "signatureTransformation", indent, Algorithms.TRANSFORMATION_ALOGRITHMS);
        this.algoTransformCombo.addModifyListener(this.modifyListener);
        Label algoMDLabel = new Label((Composite)signatureAlgorithmsGroup, 0);
        algoMDLabel.setText(Messages.signaturePrefsAlgoMD);
        this.algoMDCombo = this.addComboControl((Composite)signatureAlgorithmsGroup, algoMDLabel, "signatureMDA", indent, Algorithms.MD_ALOGRITHMS);
        this.algoMDCombo.addModifyListener(this.modifyListener);
        Label algoSignLabel = new Label((Composite)signatureAlgorithmsGroup, 0);
        algoSignLabel.setText(Messages.signaturePrefsAlgoSign);
        this.algoSignCombo = this.addComboControl((Composite)signatureAlgorithmsGroup, algoSignLabel, "signatureAlgorithm", indent, Algorithms.SIGNATURE_ALOGRITHMS);
        this.algoSignCombo.addModifyListener(this.modifyListener);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group keystoreGroup = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        keystoreGroup.setLayout((Layout)layout);
        keystoreGroup.setLayoutData((Object)gd);
        keystoreGroup.setText(Messages.keystoreAndKey);
        indent = 0;
        this.keystoreFile = new FileFieldEditor("signatureKeystoreFile", Messages.keystore, (Composite)keystoreGroup);
        this.keystoreFile.setFileExtensions(Globals.KEY_STORE_EXTENSION);
        this.keystoreFile.setChangeButtonText(Messages.open);
        this.keystoreFile.setPage((DialogPage)this);
        this.keystoreFile.setPreferenceStore(this.getPreferenceStore());
        this.keystoreFile.load();
        this.keystoreFile.fillIntoGrid((Composite)keystoreGroup, 3);
        Label keyNameLabel = new Label((Composite)keystoreGroup, 0);
        keyNameLabel.setText(Messages.key);
        this.keyNameText = this.addTextControl((Composite)keystoreGroup, keyNameLabel, "signatureKeyName", indent);
        this.keyNameText.addModifyListener(this.modifyListener);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group signatureIdGroup = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        signatureIdGroup.setLayout((Layout)layout);
        signatureIdGroup.setLayoutData((Object)gd);
        signatureIdGroup.setText(Messages.id);
        indent = 0;
        Label signIdLabel = new Label((Composite)signatureIdGroup, 0);
        signIdLabel.setText(Messages.id);
        this.signIdText = this.addTextControl((Composite)signatureIdGroup, signIdLabel, "signatureID", indent);
        this.signIdText.addModifyListener(this.modifyListener);
        return top;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.preferences_signature");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        IPreferenceStore store = this.getPreferenceStore();
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(store.getString(key)));
        this.radioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        IPreferenceStore store = this.getPreferenceStore();
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        text.setText(store.getString(key));
        this.textControls.add(text);
        return text;
    }

    private Combo addComboControl(Composite parent, Label labelControl, String key, int indent, String[] items) {
        IPreferenceStore store = this.getPreferenceStore();
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Combo combo = new Combo(parent, 2060);
        combo.setItems(items);
        combo.setData((Object)key);
        combo.setLayoutData((Object)gd);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItem(i).equals(store.getString(key))) {
                combo.select(i);
            }
            ++i;
        }
        this.comboBoxes.add(combo);
        return combo;
    }

    protected void performDefaults() {
        String key;
        IPreferenceStore store = this.getPreferenceStore();
        for (Button b : this.checkBoxes) {
            key = (String)b.getData();
            b.setSelection(store.getDefaultBoolean(key));
        }
        for (Button b : this.radioButtons) {
            String[] info = (String[])b.getData();
            b.setSelection(info[1].equals(store.getDefaultString(info[0])));
        }
        for (Text t : this.textControls) {
            key = (String)t.getData();
            t.setText(store.getDefaultString(key));
        }
        for (Combo c : this.comboBoxes) {
            key = (String)c.getData();
            int i = 0;
            while (i < c.getItemCount()) {
                if (c.getItem(i).equals(store.getDefaultString(key))) {
                    c.select(i);
                }
                ++i;
            }
        }
        this.signatureType.loadDefault();
        this.keystoreFile.loadDefault();
        super.performDefaults();
        this.validateXPath();
    }

    private void validateXPath() {
        boolean useXPathExpression = this.signXPath.getSelection();
        this.signXPathText.setEnabled(useXPathExpression);
        this.signXPathLabel.setEnabled(useXPathExpression);
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        String key;
        IPreferenceStore store = this.getPreferenceStore();
        for (Button b : this.checkBoxes) {
            key = (String)b.getData();
            store.setValue(key, b.getSelection());
        }
        for (Button b : this.radioButtons) {
            if (!b.getSelection()) continue;
            String[] info = (String[])b.getData();
            store.setValue(info[0], info[1]);
        }
        for (Text t : this.textControls) {
            key = (String)t.getData();
            store.setValue(key, t.getText());
        }
        for (Combo c : this.comboBoxes) {
            key = (String)c.getData();
            store.setValue(key, c.getItem(c.getSelectionIndex()));
        }
        this.signatureType.store();
        this.keystoreFile.store();
        return super.performOk();
    }

    private void controlChanged(Widget widget) {
        if (widget == this.signDocument || widget == this.signSelection) {
            this.signXPathLabel.setEnabled(false);
            this.signXPathText.setEnabled(false);
        } else if (widget == this.signXPath) {
            this.signXPathLabel.setEnabled(true);
            this.signXPathText.setEnabled(true);
        }
    }

    private void controlModified(Widget widget) {
    }
}

