/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.encrypt.CreateEncryption;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;

public class EncryptQuickAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private String resource;
    private String xpath = "";
    private String encryptionType;
    private String keyWrapAlgorithm;
    private String encryptionAlgorithm;
    private char[] keystorePassword;
    private String keyFile;
    private Keystore keystore;
    private String keyName;
    private char[] keyPassword;
    private String encryptionId;
    private boolean completePrefs = false;
    private static final String ERROR_TEXT = "An error occured during quick encryption";
    private static final String ACTION = "encrypt";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            PasswordDialog keystorePasswordDialog = new PasswordDialog(this.getShell(), Messages.keystorePassword, Messages.enterKeystorePassword, "");
            if (keystorePasswordDialog.open() != 0) {
                return;
            }
            this.keystorePassword = keystorePasswordDialog.getValue().toCharArray();
            PasswordDialog privateKeyPasswordDialog = new PasswordDialog(this.getShell(), Messages.keyPassword, Messages.enterKeyPassword, "");
            if (privateKeyPasswordDialog.open() != 0) {
                return;
            }
            this.keyPassword = privateKeyPasswordDialog.getValue().toCharArray();
            if (this.checkPasswords()) {
                try {
                    if (this.loadKeystore()) {
                        this.encryptData();
                    } else {
                        this.showError(Messages.error, Messages.failedLoadingKeystore);
                    }
                }
                catch (Exception ex) {
                    this.showErrorDialog(Messages.error, Messages.encryptingError, ex);
                    this.log(ERROR_TEXT, ex);
                }
            }
        }
    }

    private boolean loadKeystore() throws Exception {
        block3: {
            try {
                this.keystore = new Keystore(this.keyFile, this.keystorePassword.toString(), "JCEKS");
                this.keystore.load();
                if (this.keystore.containsKey(this.keyName)) break block3;
                return false;
            }
            catch (Exception ex) {
                this.log(ERROR_TEXT, ex);
                return false;
            }
        }
        return this.keystore.getSecretKey(this.keyName, this.keyPassword) != null;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.resource = store.getString("encryptionResource");
        this.encryptionType = store.getString("encryptionType");
        this.keyWrapAlgorithm = store.getString("encryptionKeyWrap");
        this.encryptionAlgorithm = store.getString("encryptionEncryption");
        this.keyName = store.getString("encryptionKeyName");
        this.keyFile = store.getString("encryptionKeyStore");
        this.encryptionId = store.getString("encryptionID");
        if (this.resource != null && "xpath".equals(this.resource)) {
            this.xpath = store.getString("encryptionXPath");
        }
    }

    private void encryptData() throws Exception {
        final Encryption encryption = new Encryption();
        encryption.setResource(this.resource);
        encryption.setEncryptionType(this.encryptionType);
        encryption.setXpath(this.xpath);
        encryption.setContent(false);
        encryption.setBsp(false);
        encryption.setKeyWrapAlgorithm(this.keyWrapAlgorithm);
        encryption.setEncryptionAlgorithm(this.encryptionAlgorithm);
        encryption.setKeystore(this.keystore);
        encryption.setKeystorePassword(this.keystorePassword);
        encryption.setKeyName(this.keyName);
        encryption.setKeyPassword(this.keyPassword);
        encryption.setEncryptionId(this.encryptionId);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
        if (this.editor != null && this.editor.isEditable()) {
            if (this.editor.isDirty()) {
                this.saveEditorContent(this.editor);
            }
            IEditorInput input = this.editor.getEditorInput();
            this.file = (IFile)input.getAdapter(IFile.class);
            if (this.file != null) {
                final IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
                encryption.setFile(this.file.getLocation().toString());
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.encryptionTaskInfo, 3);
                            CreateEncryption content = new CreateEncryption();
                            Document doc = null;
                            if ("selection".equals(EncryptQuickAction.this.resource)) {
                                ITextSelection textSelection = (ITextSelection)EncryptQuickAction.this.editor.getSelectionProvider().getSelection();
                                if (textSelection != null && !textSelection.isEmpty() && textSelection.getLength() > 0 && EncryptQuickAction.this.parseSelection(textSelection.getText())) {
                                    doc = content.encrypt(encryption, textSelection.getText(), monitor);
                                } else {
                                    EncryptQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            EncryptQuickAction.this.showInfo(Messages.invalidTextSelection, Messages.invalidTextSelectionText);
                                        }
                                    });
                                }
                            } else {
                                doc = content.encrypt(encryption, null, monitor);
                            }
                            if (doc != null) {
                                document.set(Utils.docToString((Document)doc, (boolean)true));
                            }
                            monitor.done();
                        }
                        catch (Exception ex) {
                            EncryptQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EncryptQuickAction.this.showErrorDialog(Messages.error, Messages.encryptingError, ex);
                                    EncryptQuickAction.this.log(EncryptQuickAction.ERROR_TEXT, ex);
                                }
                            });
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            } else {
                this.showInfo(Messages.quickEncryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
            if ("selection".equals(this.resource)) {
                this.showInfo(Messages.quickEncryptionImpossible, Messages.quickEncryptionImpossibleText);
            } else {
                final String filename = this.file.getLocation().toString();
                encryption.setFile(filename);
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.encryptionTaskInfo, 3);
                            CreateEncryption content = new CreateEncryption();
                            Document doc = content.encrypt(encryption, null, monitor);
                            if (doc != null) {
                                FileWriter fw = new FileWriter(filename);
                                fw.write(Utils.docToString((Document)doc, (boolean)true));
                                fw.flush();
                                fw.close();
                            }
                            monitor.done();
                        }
                        catch (Exception ex) {
                            EncryptQuickAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EncryptQuickAction.this.showErrorDialog(Messages.error, Messages.encryptingError, ex);
                                    EncryptQuickAction.this.log(EncryptQuickAction.ERROR_TEXT, ex);
                                }
                            });
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                }
                catch (InvocationTargetException ite) {
                    this.log(ERROR_TEXT, ite);
                }
                catch (InterruptedException ie) {
                    this.log(ERROR_TEXT, ie);
                }
            }
        } else {
            this.showInfo(Messages.quickEncryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
        }
    }

    private boolean checkPreferences() {
        int result = 2;
        if (this.resource == null || "".equals(this.resource)) {
            result = this.showMissingParameterDialog(Messages.quickEncryptionTitle, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingResource), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.resource != null && "xpath".equals(this.resource) && (this.xpath == null || this.xpath.equals(""))) {
            result = this.showMissingParameterDialog(Messages.quickEncryptionTitle, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingXPathExpression), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.keyFile == null || "".equals(this.keyFile)) {
            result = this.showMissingParameterDialog(Messages.quickEncryptionTitle, NLS.bind((String)Messages.missingParameter, (Object)Messages.missingKeystore), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }

    private boolean checkPasswords() {
        if (this.keystorePassword == null || this.keystorePassword.length == 0) {
            this.showInfo(Messages.quickSignatureTitle, Messages.missingKeystorePassword);
            return false;
        }
        if (this.keyPassword == null || this.keyPassword.length == 0) {
            this.showInfo(Messages.quickSignatureTitle, Messages.missingKeyPassword);
            return false;
        }
        return true;
    }
}

