/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.verify.VerifyDocument;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.verify.SignatureView;

public class RefreshSignatures
extends XmlSecurityActionAdapter
implements IViewActionDelegate {
    private static final String ACTION = "verify";

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbench.getActivePage();
        final IEditorPart editor = page.getActiveEditor();
        if (editor != null) {
            if (editor.isDirty()) {
                if (editor.getTitle() != null && editor.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editor.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        this.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        this.log("Error while saving editor content", ie);
                    }
                } else {
                    editor.doSaveAs();
                }
            }
            try {
                IViewPart vp;
                ArrayList results = new ArrayList();
                VerifyDocument verify = new VerifyDocument();
                IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
                if (file != null) {
                    results = verify.verify(file.getLocation().toString());
                } else {
                    this.showInfo(Messages.signaturesView, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
                }
                if (results.size() == 0) {
                    this.showInfo(Messages.signaturesView, Messages.noSignaturesInDocument);
                }
                if ((vp = page.showView("org.eclipse.wst.xml.security.ui.SignatureView")) instanceof SignatureView) {
                    ((SignatureView)vp).setInput(results);
                }
            }
            catch (XMLSignatureException xmlse) {
                this.showError(Messages.invalidXml, xmlse.getLocalizedMessage());
            }
            catch (KeyResolverException kre) {
                this.showError(Messages.invalidCertificate, kre.getLocalizedMessage());
            }
            catch (Exception ex) {
                this.showError(Messages.verificationError, ex.getLocalizedMessage());
                this.log("Error during verification of XML signature", ex);
            }
        } else {
            this.showInfo(Messages.signaturesView, Messages.noDocument);
        }
    }

    public void init(IViewPart view) {
    }
}

