/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.sign.CreateSignature;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.actions.EncryptNewAction;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.sign.NewSignatureWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class SignNewAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private ITextSelection textSelection = null;
    private static final String ERROR_TEXT = "An error occured during signing";
    private static final String ACTION = "sign";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.createSignature();
    }

    private void createSignature() {
        try {
            NewSignatureWizard sigWizard = new NewSignatureWizard();
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
            if (this.editor != null && this.editor.isEditable()) {
                if (this.editor.isDirty()) {
                    this.saveEditorContent(this.editor);
                }
                IEditorInput input = this.editor.getEditorInput();
                this.file = (IFile)input.getAdapter(IFile.class);
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
                this.textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
                boolean validSelection = this.parseSelection(this.textSelection.getText());
                if (this.file != null) {
                    if (validSelection) {
                        sigWizard.init(this.file, this.textSelection);
                    } else {
                        sigWizard.init(this.file);
                    }
                    CreateSignature signature = new CreateSignature();
                    this.signData(signature, sigWizard, document, "");
                    if (sigWizard.getModel().getLaunchEncryptionWizard()) {
                        this.callEncryptionWizard();
                    }
                } else {
                    this.showInfo(Messages.signatureImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
                }
            } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
                sigWizard.init(this.file);
                CreateSignature signature = new CreateSignature();
                this.signData(signature, sigWizard, null, this.file.getLocation().toString());
                if (sigWizard.getModel().getLaunchEncryptionWizard()) {
                    this.callEncryptionWizard();
                }
            } else {
                this.showInfo(Messages.signatureImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        }
        catch (SAXParseException spe) {
            this.showError(Messages.parsingError, String.valueOf(Messages.parsingErrorText) + spe.getLocalizedMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError(Messages.keystore, Messages.keystoreNotFound);
        }
        catch (IOException ioe) {
            this.showError(Messages.keystore, String.valueOf(Messages.keystoreError) + ioe.getLocalizedMessage());
        }
        catch (Exception ex) {
            this.showErrorDialog(Messages.error, Messages.signingError, ex);
            this.log(ERROR_TEXT, ex);
        }
    }

    private void signData(final CreateSignature data, final NewSignatureWizard wizard, final IDocument document, final String filename) throws Exception {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job("XML Signature"){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.signatureTaskInfo, 5);
                            Document doc = data.sign(wizard.getModel(), SignNewAction.this.textSelection.getText(), monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                    break block8;
                                }
                                FileOutputStream fos = new FileOutputStream(filename);
                                XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex) {
                                SignNewAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        SignNewAction.this.showErrorDialog(Messages.error, Messages.signingError, ex);
                                        SignNewAction.this.log(SignNewAction.ERROR_TEXT, ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }

    private void callEncryptionWizard() {
        EncryptNewAction encrypt = new EncryptNewAction();
        encrypt.encryptAfterSignature(this.file);
    }

    public void signAfterEncryption(IFile encryptedFile) {
        this.file = encryptedFile;
        this.createSignature();
    }
}

