/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.dialogs.MissingPreferenceDialog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlSecurityActionAdapter
implements IObjectActionDelegate {
    private IWorkbenchPart workbenchPart = null;
    private Shell shell = null;

    public abstract void run(IAction var1);

    public abstract void selectionChanged(IAction var1, ISelection var2);

    public Shell getShell() {
        return this.shell;
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public void setActivePart(IAction action, IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
        this.shell = workbenchPart.getSite().getShell();
    }

    protected void log(String message, Exception ex) {
        Status status = new Status(4, XSTUIPlugin.getDefault().getBundle().getSymbolicName(), 0, message, (Throwable)ex);
        XSTUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    protected void showInfo(String title, String message) {
        MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
    }

    protected void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    protected void showErrorDialog(String title, String message, Exception ex) {
        String reason = ex.getMessage();
        if (reason == null || "".equals(reason)) {
            reason = Messages.errorReasonUnavailable;
        }
        Status status = new Status(4, XSTUIPlugin.getDefault().getBundle().getSymbolicName(), 0, reason, (Throwable)ex);
        ErrorDialog.openError((Shell)this.shell, (String)title, (String)message, (IStatus)status);
    }

    protected int showMissingParameterDialog(String title, String message, String prefId) {
        MissingPreferenceDialog dialog = new MissingPreferenceDialog(this.shell, title, message, prefId);
        return dialog.open();
    }

    protected boolean parseSelection(String textSelection) {
        if (textSelection == null || textSelection.trim().length() == 0) {
            return false;
        }
        Pattern p = Pattern.compile("[^<>]+");
        Matcher m = p.matcher(textSelection);
        if (!m.matches()) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            try {
                XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                xmlReader.setErrorHandler(null);
                xmlReader.parse(new InputSource(new StringReader(textSelection)));
            }
            catch (IOException iOException) {
                return false;
            }
            catch (SAXException sAXException) {
                return false;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return false;
            }
            return true;
        }
        return true;
    }

    protected void saveEditorContent(final ITextEditor openedEditor) {
        if (openedEditor.getTitle() != null && openedEditor.getTitle().length() > 0) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    openedEditor.doSave(monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException ite) {
                this.log("Error while saving editor content", ite);
            }
            catch (InterruptedException ie) {
                this.log("Error while saving editor content", ie);
            }
        } else {
            openedEditor.doSaveAs();
        }
    }
}

