/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.verify;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.eclipse.wst.xml.security.ui.actions.ShowSignatureProperties;
import org.eclipse.wst.xml.security.ui.verify.Messages;
import org.eclipse.wst.xml.security.ui.verify.SignatureComparator;
import org.eclipse.wst.xml.security.ui.verify.SignatureLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureView
extends ViewPart {
    private TableViewer viewer;
    public static final String ID = "org.eclipse.wst.xml.security.ui.SignatureView";
    private Clipboard clipboard = null;

    public void setInput(ArrayList<VerificationResult> results) {
        this.viewer.setLabelProvider((IBaseLabelProvider)new SignatureLabelProvider());
        this.viewer.setInput(results);
        this.updateViewInfo(results);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SignatureLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0x1000000);
        column.getColumn().setText("");
        column.getColumn().setToolTipText(Messages.signatureStatus);
        column.getColumn().setWidth(50);
        column.getColumn().setMoveable(true);
        SignatureComparator signatureSorter = new SignatureComparator((ColumnViewer)this.viewer, column){

            protected int doCompare(Viewer viewer, Object o1, Object o2) {
                VerificationResult result1 = (VerificationResult)o1;
                VerificationResult result2 = (VerificationResult)o2;
                if (result1 != null && result2 != null) {
                    return result1.getStatus().compareToIgnoreCase(result2.getStatus());
                }
                return 0;
            }
        };
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.signatureId);
        column.getColumn().setToolTipText(Messages.signatureId);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(true);
        new SignatureComparator((ColumnViewer)this.viewer, column){

            protected int doCompare(Viewer viewer, Object o1, Object o2) {
                VerificationResult result1 = (VerificationResult)o1;
                VerificationResult result2 = (VerificationResult)o2;
                if (result1 != null && result2 != null) {
                    return result1.getId().compareToIgnoreCase(result2.getId());
                }
                return 0;
            }
        };
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.signatureType);
        column.getColumn().setToolTipText(Messages.signatureType);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(true);
        new SignatureComparator((ColumnViewer)this.viewer, column){

            protected int doCompare(Viewer viewer, Object o1, Object o2) {
                VerificationResult result1 = (VerificationResult)o1;
                VerificationResult result2 = (VerificationResult)o2;
                if (result1 != null && result2 != null) {
                    return result1.getType().compareToIgnoreCase(result2.getType());
                }
                return 0;
            }
        };
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.signatureAlgorithm);
        column.getColumn().setToolTipText(Messages.signatureAlgorithm);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(true);
        new SignatureComparator((ColumnViewer)this.viewer, column){

            protected int doCompare(Viewer viewer, Object o1, Object o2) {
                VerificationResult result1 = (VerificationResult)o1;
                VerificationResult result2 = (VerificationResult)o2;
                if (result1 != null && result2 != null) {
                    return result1.getAlgorithm().compareToIgnoreCase(result2.getAlgorithm());
                }
                return 0;
            }
        };
        signatureSorter.setSorter(signatureSorter, 1);
        this.initCopyAndPaste();
        this.initContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.updateViewInfo(new ArrayList<VerificationResult>());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.wst.xml.security.doc.signature_view");
    }

    private void initCopyAndPaste() {
        this.clipboard = new Clipboard(this.getSite().getShell().getDisplay());
        Action copyAction = new Action(){

            public void run() {
                SignatureView.this.setClipboardData();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("copy", (IAction)copyAction);
    }

    private boolean setClipboardData() {
        VerificationResult result = this.getSelectedItem();
        if (result == null) {
            return false;
        }
        String text = result.resultToReadableString();
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{text};
        this.clipboard.setContents(data, transfers);
        return true;
    }

    private VerificationResult getSelectedItem() {
        Object o;
        ISelection selection = this.viewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof VerificationResult) {
            return (VerificationResult)o;
        }
        return null;
    }

    private void initContextMenu() {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IContributionItem)new Separator("additions"));
        bars.getToolBarManager().add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VerificationResult result = SignatureView.this.getSelectedItem();
                if (result != null) {
                    new ShowSignatureProperties().run(result);
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void updateViewInfo(ArrayList<VerificationResult> results) {
        int totalSignatures = 0;
        int validSignatures = 0;
        int invalidSignatures = 0;
        int unknownSignatures = 0;
        try {
            totalSignatures = results.size();
            for (VerificationResult result : results) {
                if ("valid".equals(result.getStatus())) {
                    ++validSignatures;
                    continue;
                }
                if ("invalid".equals(result.getStatus())) {
                    ++invalidSignatures;
                    continue;
                }
                ++unknownSignatures;
            }
        }
        catch (Exception exception) {
            totalSignatures = 0;
            validSignatures = 0;
            invalidSignatures = 0;
            unknownSignatures = 0;
        }
        this.setContentDescription(NLS.bind((String)Messages.signatureInfo, (Object[])new Object[]{totalSignatures, validSignatures, invalidSignatures, unknownSignatures}));
    }

    public TableViewer getSignaturesViewer() {
        return this.viewer;
    }
}

