/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            return this.computeCompletionProposals((JavaContentAssistInvocationContext)context);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        CompletionContext completionContext = context.getCoreContext();
        int tokenStart = completionContext.getOffset();
        ICompilationUnit source = context.getCompilationUnit();
        try {
            IJavaElement javaElement = source.getElementAt(tokenStart);
            if (javaElement != null) {
                CompilationUnit compilationUnit = JDTUtils.getCompilationUnit((ICompilationUnit)source);
                int elementType = javaElement.getElementType();
                if (elementType == 11) {
                    PackageDeclaration packageDeclaration = compilationUnit.getPackage();
                    List packageAnnotations = packageDeclaration.annotations();
                    for (Annotation annotation : packageAnnotations) {
                        NormalAnnotation normalAnnotation;
                        MemberValuePair memberValuePair;
                        if (!(annotation instanceof NormalAnnotation) || (memberValuePair = this.getMemberValuePairForPosition(normalAnnotation = (NormalAnnotation)annotation, tokenStart)) == null) continue;
                        return this.getCompletionProposalsForASTNode(normalAnnotation, memberValuePair, (ASTNode)packageDeclaration);
                    }
                }
                if (elementType == 7 || elementType == 8) {
                    return this.getCompletionProposalsForJavaElement(AnnotationUtils.getExtendedModifiers((CompilationUnit)compilationUnit, (IJavaElement)javaElement), javaElement, tokenStart);
                }
                if (elementType == 9) {
                    SingleVariableDeclaration parameter = AnnotationUtils.getMethodParameter((CompilationUnit)compilationUnit, (IMethod)((IMethod)javaElement), (int)tokenStart);
                    if (parameter != null) {
                        return this.getCompletionProposalsForASTNode(parameter.modifiers(), (ASTNode)parameter, tokenStart);
                    }
                    return this.getCompletionProposalsForJavaElement(AnnotationUtils.getExtendedModifiers((CompilationUnit)compilationUnit, (IJavaElement)javaElement), javaElement, tokenStart);
                }
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForASTNode(List<IExtendedModifier> modifiers, ASTNode astNode, int offset) {
        for (IExtendedModifier extendedModifier : modifiers) {
            NormalAnnotation normalAnnotation;
            MemberValuePair memberValuePair;
            if (!extendedModifier.isAnnotation() || !(extendedModifier instanceof NormalAnnotation) || (memberValuePair = this.getMemberValuePairForPosition(normalAnnotation = (NormalAnnotation)extendedModifier, offset)) == null) continue;
            return this.getCompletionProposalsForASTNode(normalAnnotation, memberValuePair, astNode);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForJavaElement(List<IExtendedModifier> modifiers, IJavaElement javaElement, int offset) {
        for (IExtendedModifier extendedModifier : modifiers) {
            NormalAnnotation normalAnnotation;
            MemberValuePair memberValuePair;
            if (!extendedModifier.isAnnotation() || !(extendedModifier instanceof NormalAnnotation) || (memberValuePair = this.getMemberValuePairForPosition(normalAnnotation = (NormalAnnotation)extendedModifier, offset)) == null) continue;
            return this.getCompletionProposalsForJavaElement(normalAnnotation, memberValuePair, javaElement);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForASTNode(NormalAnnotation normalAnnotation, MemberValuePair memberValuePair, ASTNode astNode) {
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationAttributeInitializerForName((Name)normalAnnotation.getTypeName());
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getCompletionProposalsForMemberValuePair(astNode, memberValuePair);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getCompletionProposalsForJavaElement(NormalAnnotation normalAnnotation, MemberValuePair memberValuePair, IJavaElement javaElement) {
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationAttributeInitializerForName((Name)normalAnnotation.getTypeName());
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getCompletionProposalsForMemberValuePair(javaElement, memberValuePair);
        }
        return Collections.emptyList();
    }

    private MemberValuePair getMemberValuePairForPosition(NormalAnnotation normalAnnotation, int offset) {
        List memberValuePairs = normalAnnotation.values();
        for (MemberValuePair memberValuePair : memberValuePairs) {
            Expression value = memberValuePair.getValue();
            int valueStartPosition = value.getStartPosition();
            int valueLength = value.getLength();
            if (offset < valueStartPosition || offset > valueStartPosition + valueLength) continue;
            return memberValuePair;
        }
        return null;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

