/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.soap.SOAPBinding;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization.BindingTypeCompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTypeAttributeInitializer
extends AnnotationAttributeInitializer {
    private static final String SOAPBinding_SOAP11HTTP_BINDING = "SOAPBinding.SOAP11HTTP_BINDING";
    private static final String SOAPBinding_SOAP12HTTP_BINDING = "SOAPBinding.SOAP12HTTP_BINDING";
    private static final String SOAPBinding_SOAP11HTTP_MTOM_BINDING = "SOAPBinding.SOAP11HTTP_MTOM_BINDING";
    private static final String SOAPBinding_SOAP12HTTP_MTOM_BINDING = "SOAPBinding.SOAP12HTTP_MTOM_BINDING";
    private static final String HTTPBinding_HTTP_BINDING = "HTTPBinding.HTTP_BINDING";
    private static final String SOAP_BINDING = "javax.xml.ws.soap.SOAPBinding";
    private static final String HTTP_BINDING = "javax.xml.ws.http.HTTPBinding";

    public BindingTypeAttributeInitializer() {
        JAXWSUIPlugin.getDefault().getImageRegistry().put(SOAP_BINDING, JAXWSUIPlugin.getImageDescriptor("icons/obj16/soapbinding_obj.gif").createImage());
        JAXWSUIPlugin.getDefault().getImageRegistry().put(HTTP_BINDING, JAXWSUIPlugin.getImageDescriptor("icons/obj16/httpbinding_obj.gif").createImage());
    }

    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 7) {
            MemberValuePair value = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"value", (Object)this.getDefault());
            memberValuePairs.add(value);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals;
        block5: {
            completionProposals = new ArrayList<ICompletionProposal>();
            if (javaElement.getElementType() != 7) break block5;
            IType type = (IType)javaElement;
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("value")) {
                String value = memberValuePair.getValue().toString();
                if (value.equals("$missing$") || value.charAt(0) != '\"') {
                    Map<String, String> bindings = this.getShortNameBindingsMap();
                    for (Map.Entry<String, String> bindingEntry : bindings.entrySet()) {
                        String proposal = bindingEntry.getKey();
                        String fullyQualifiedTypeName = bindingEntry.getValue();
                        int replacementOffset = memberValuePair.getValue().getStartPosition();
                        int replacementLength = memberValuePair.getValue().getLength();
                        Image image = JAXWSUIPlugin.getDefault().getImageRegistry().get(fullyQualifiedTypeName);
                        completionProposals.add((ICompletionProposal)new BindingTypeCompletionProposal(proposal, type.getCompilationUnit(), replacementOffset, replacementLength, image, new StyledString(proposal), 5, fullyQualifiedTypeName));
                    }
                } else {
                    Map<String, String> bindings = this.getQualifiedNameBindingsMap();
                    for (Map.Entry<String, String> bindingEntry : bindings.entrySet()) {
                        String proposal = bindingEntry.getKey();
                        Image image = JAXWSUIPlugin.getDefault().getImageRegistry().get(bindingEntry.getValue());
                        completionProposals.add((ICompletionProposal)this.createCompletionProposal(proposal, memberValuePair.getValue(), image, this.getDisplayString(proposal)));
                    }
                }
            }
        }
        return completionProposals;
    }

    public String getDefault() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    private String getDisplayString(String binding) {
        if (binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            return SOAPBinding_SOAP11HTTP_BINDING;
        }
        if (binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return SOAPBinding_SOAP12HTTP_BINDING;
        }
        if (binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            return SOAPBinding_SOAP11HTTP_MTOM_BINDING;
        }
        if (binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            return SOAPBinding_SOAP12HTTP_MTOM_BINDING;
        }
        if (binding.equals("http://www.w3.org/2004/08/wsdl/http")) {
            return HTTPBinding_HTTP_BINDING;
        }
        return binding;
    }

    private Map<String, String> getQualifiedNameBindingsMap() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("http://schemas.xmlsoap.org/wsdl/soap/http", SOAPBinding.class.getCanonicalName());
        bindings.put("http://www.w3.org/2003/05/soap/bindings/HTTP/", SOAPBinding.class.getCanonicalName());
        bindings.put("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", SOAPBinding.class.getCanonicalName());
        bindings.put("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", SOAPBinding.class.getCanonicalName());
        bindings.put("http://www.w3.org/2004/08/wsdl/http", HTTPBinding.class.getCanonicalName());
        return bindings;
    }

    private Map<String, String> getShortNameBindingsMap() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put(SOAPBinding_SOAP11HTTP_BINDING, SOAPBinding.class.getCanonicalName());
        bindings.put(SOAPBinding_SOAP12HTTP_BINDING, SOAPBinding.class.getCanonicalName());
        bindings.put(SOAPBinding_SOAP11HTTP_MTOM_BINDING, SOAPBinding.class.getCanonicalName());
        bindings.put(SOAPBinding_SOAP12HTTP_MTOM_BINDING, SOAPBinding.class.getCanonicalName());
        bindings.put(HTTPBinding_HTTP_BINDING, HTTPBinding.class.getCanonicalName());
        return bindings;
    }
}

