/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.preferences;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.AnnotationsComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.BlankRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.CXF20WSDL2JavaPreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.CXF21WSDL2JavaPreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSDLRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.SpringConfigComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Version;

public class CXFRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IStatus CXF_LOCATION_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", null);
    private IStatus OK_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", "");
    private Pattern digitPattern = Pattern.compile("\\d");
    private Button browseButton;
    private Text cxfHomeDirText;
    private Label cxfToolVersionLabel;
    private Button exportCXFClasspathContainerButton;
    private CXFContext context;
    private Java2WSDLRuntimePreferencesComposite java2WSDLRuntimePreferencesComposite;
    private Java2WSRuntimePreferencesComposite java2WSRuntimePreferencesComposite;
    private CXF20WSDL2JavaPreferencesComposite cxf20WSDL2JavaPreferencesComposite;
    private CXF21WSDL2JavaPreferencesComposite cxf21WSDL2JavaPreferencesComposite;
    private AnnotationsComposite annotationsComposite;
    private SpringConfigComposite springConfigComposite;
    private StackLayout java2WSStackLayout;
    private StackLayout wsdl2javaStackLayout;
    private StackLayout jaxwsStackLayout;
    private StackLayout springConfigStackLayout;
    private Composite java2WSPreferncesGroup;
    private Composite wsdl2JavaPreferencesGroup;
    private Composite jaxwsPreferencesGroup;
    private Composite springConfigPreferncesGroup;
    private Composite java2WSDLPreferencesComposite;
    private Composite java2WSPreferencesComposite;
    private Composite jaxwsPreferencesComposite;
    private Composite wsdl2Java20PreferencesComposite;
    private Composite wsdl2Java21PreferencesComposite;
    private Composite springPreferencesComposite;
    private BlankRuntimePreferencesComposite java2WSBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite wsdl2JavaBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite jaxwsBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite springConfigBlankPreferencesComposite;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.context = CXFCorePlugin.getDefault().getJava2WSContext();
        final Composite composite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        composite.setLayout((Layout)mainLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        TabFolder cxfPreferenceTab = new TabFolder(composite, 0);
        gridData = new GridData(1808);
        cxfPreferenceTab.setLayoutData((Object)gridData);
        TabItem runtimeInstalLocationItem = new TabItem(cxfPreferenceTab, 0);
        runtimeInstalLocationItem.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_NAME);
        runtimeInstalLocationItem.setToolTipText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_TOOLTIP);
        Composite runtimeGroup = new Composite((Composite)cxfPreferenceTab, 0);
        runtimeInstalLocationItem.setControl((Control)runtimeGroup);
        runtimeGroup.setToolTipText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_TOOLTIP);
        GridLayout runtimeLoactionlayout = new GridLayout();
        runtimeLoactionlayout.numColumns = 3;
        runtimeLoactionlayout.marginHeight = 10;
        runtimeGroup.setLayout((Layout)runtimeLoactionlayout);
        gridData = new GridData(1808);
        runtimeGroup.setLayoutData((Object)gridData);
        Label label = new Label(runtimeGroup, 0);
        label.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_CXF_HOME_DIR_LABEL);
        this.cxfHomeDirText = new Text(runtimeGroup, 2048);
        if (this.context.getCxfRuntimeLocation() != null) {
            this.cxfHomeDirText.setText(this.context.getCxfRuntimeLocation());
        }
        gridData = new GridData(768);
        this.cxfHomeDirText.setLayoutData((Object)gridData);
        this.cxfHomeDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CXFRuntimePreferencePage.this.context.setCxfRuntimeLocation(CXFRuntimePreferencePage.this.cxfHomeDirText.getText());
                CXFRuntimePreferencePage.this.updateStatus();
                CXFRuntimePreferencePage.this.handlePreferenceControls();
            }
        });
        this.browseButton = new Button(runtimeGroup, 0);
        this.browseButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_BROWSE_BUTTON_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fileDialog = new DirectoryDialog(composite.getShell());
                String fileName = fileDialog.open();
                if (fileName != null) {
                    CXFRuntimePreferencePage.this.cxfHomeDirText.setText(fileName);
                    CXFRuntimePreferencePage.this.context.setCxfRuntimeLocation(CXFRuntimePreferencePage.this.cxfHomeDirText.getText());
                }
            }
        });
        Label cxfVersionLabel = new Label(runtimeGroup, 0);
        cxfVersionLabel.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_CXF_VERSON_LABEL);
        gridData = new GridData(4, 4, false, false);
        cxfVersionLabel.setLayoutData((Object)gridData);
        this.cxfToolVersionLabel = new Label(runtimeGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        this.cxfToolVersionLabel.setLayoutData((Object)gridData);
        Label paddingLabel = new Label(runtimeGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        paddingLabel.setLayoutData((Object)gridData);
        this.exportCXFClasspathContainerButton = new Button(runtimeGroup, 32);
        this.exportCXFClasspathContainerButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_EXPORT_CXF_CLASSPATH_CONTAINER);
        this.exportCXFClasspathContainerButton.setSelection(this.context.isExportCXFClasspathContainer());
        this.exportCXFClasspathContainerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CXFRuntimePreferencePage.this.context.setExportCXFClasspathContainer(((Button)e.widget).getSelection());
            }
        });
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        this.exportCXFClasspathContainerButton.setLayoutData((Object)gridData);
        if (this.context.getCxfRuntimeVersion().length() > 0) {
            this.cxfToolVersionLabel.setText(String.valueOf(this.context.getCxfRuntimeEdition()) + " " + this.context.getCxfRuntimeVersion());
            this.exportCXFClasspathContainerButton.setEnabled(true);
        } else {
            this.exportCXFClasspathContainerButton.setEnabled(false);
        }
        TabItem java2WSTabItem = new TabItem(cxfPreferenceTab, 0);
        java2WSTabItem.setText(CXFUIMessages.JAVA2WS_PREFERENCES_TAB_NAME);
        java2WSTabItem.setToolTipText(CXFUIMessages.JAVA2WS_PREFERENCES_TAB_TOOLTIP);
        this.java2WSPreferncesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.java2WSStackLayout = new StackLayout();
        this.java2WSPreferncesGroup.setLayout((Layout)this.java2WSStackLayout);
        this.java2WSDLPreferencesComposite = new Composite(this.java2WSPreferncesGroup, 0);
        GridLayout java2WSGridLayout = new GridLayout(1, true);
        this.java2WSDLPreferencesComposite.setLayout((Layout)java2WSGridLayout);
        this.java2WSDLRuntimePreferencesComposite = new Java2WSDLRuntimePreferencesComposite(this.java2WSDLPreferencesComposite, 0, cxfPreferenceTab);
        this.java2WSDLRuntimePreferencesComposite.addControls();
        this.java2WSPreferencesComposite = new Composite(this.java2WSPreferncesGroup, 0);
        GridLayout java2WSDLGridLayout = new GridLayout(1, true);
        this.java2WSPreferencesComposite.setLayout((Layout)java2WSDLGridLayout);
        this.java2WSRuntimePreferencesComposite = new Java2WSRuntimePreferencesComposite(this.java2WSPreferencesComposite, 0, cxfPreferenceTab);
        this.java2WSRuntimePreferencesComposite.addControls();
        this.java2WSBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.java2WSPreferncesGroup, 0);
        java2WSTabItem.setControl((Control)this.java2WSPreferncesGroup);
        TabItem wsdl2JavaTabItem = new TabItem(cxfPreferenceTab, 0);
        wsdl2JavaTabItem.setText(CXFUIMessages.WSDL2JAVA_PREFERENCES_TAB_NAME);
        wsdl2JavaTabItem.setToolTipText(CXFUIMessages.WSDL2JAVA_PREFERENCES_TAB_TOOLTIP);
        this.wsdl2JavaPreferencesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.wsdl2javaStackLayout = new StackLayout();
        this.wsdl2JavaPreferencesGroup.setLayout((Layout)this.wsdl2javaStackLayout);
        this.wsdl2Java20PreferencesComposite = new Composite(this.wsdl2JavaPreferencesGroup, 0);
        GridLayout wsdl2Java20GridLayout = new GridLayout(1, true);
        this.wsdl2Java20PreferencesComposite.setLayout((Layout)wsdl2Java20GridLayout);
        this.cxf20WSDL2JavaPreferencesComposite = new CXF20WSDL2JavaPreferencesComposite(this.wsdl2Java20PreferencesComposite, 0);
        this.cxf20WSDL2JavaPreferencesComposite.addControls();
        this.wsdl2Java21PreferencesComposite = new Composite(this.wsdl2JavaPreferencesGroup, 0);
        GridLayout wsdl2Java21GridLayout = new GridLayout(1, true);
        this.wsdl2Java21PreferencesComposite.setLayout((Layout)wsdl2Java21GridLayout);
        this.cxf21WSDL2JavaPreferencesComposite = new CXF21WSDL2JavaPreferencesComposite(this.wsdl2Java21PreferencesComposite, 0);
        this.cxf21WSDL2JavaPreferencesComposite.addControls();
        this.wsdl2JavaBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.wsdl2JavaPreferencesGroup, 0);
        wsdl2JavaTabItem.setControl((Control)this.wsdl2JavaPreferencesGroup);
        TabItem annotationsTabItem = new TabItem(cxfPreferenceTab, 0);
        annotationsTabItem.setText(CXFUIMessages.ANNOTATIONS_PREFERENCES_TAB_NAME);
        annotationsTabItem.setToolTipText(CXFUIMessages.ANNOTATIONS_PREFERENCES_TAB_TOOLTIP);
        this.jaxwsPreferencesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.jaxwsStackLayout = new StackLayout();
        this.jaxwsPreferencesGroup.setLayout((Layout)this.jaxwsStackLayout);
        this.jaxwsPreferencesComposite = new Composite(this.jaxwsPreferencesGroup, 0);
        GridLayout jaxwsGridLayout = new GridLayout(1, true);
        this.jaxwsPreferencesComposite.setLayout((Layout)jaxwsGridLayout);
        this.annotationsComposite = new AnnotationsComposite(this.jaxwsPreferencesComposite, 4);
        this.jaxwsBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.jaxwsPreferencesGroup, 0);
        annotationsTabItem.setControl((Control)this.jaxwsPreferencesGroup);
        TabItem springConfigTabItem = new TabItem(cxfPreferenceTab, 0);
        springConfigTabItem.setText(CXFUIMessages.SPRING_CONFIG_PREFERENCES_TAB_NAME);
        springConfigTabItem.setToolTipText(CXFUIMessages.SPRING_CONFIG_PREFERENCES_TAB_TOOLTIP);
        this.springConfigPreferncesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.springConfigStackLayout = new StackLayout();
        this.springConfigPreferncesGroup.setLayout((Layout)this.springConfigStackLayout);
        this.springPreferencesComposite = new Composite(this.springConfigPreferncesGroup, 0);
        GridLayout springGridLayout = new GridLayout(1, true);
        this.springPreferencesComposite.setLayout((Layout)springGridLayout);
        this.springConfigComposite = new SpringConfigComposite(this.springPreferencesComposite, 4);
        this.springConfigBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.springConfigPreferncesGroup, 0);
        springConfigTabItem.setControl((Control)this.springConfigPreferncesGroup);
        this.handlePreferenceControls();
        return composite;
    }

    private void handlePreferenceControls() {
        if (this.context.getCxfRuntimeLocation().equals("") || this.context.getCxfRuntimeVersion().equals("")) {
            this.java2WSStackLayout.topControl = this.java2WSBlankPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2JavaBlankPreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsBlankPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springConfigBlankPreferencesComposite;
        } else if (this.context.getCxfRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSStackLayout.topControl = this.java2WSPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2Java21PreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springPreferencesComposite;
        } else {
            this.java2WSStackLayout.topControl = this.java2WSDLPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2Java20PreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springPreferencesComposite;
        }
        this.java2WSPreferncesGroup.layout();
        this.wsdl2JavaPreferencesGroup.layout();
        this.jaxwsPreferencesGroup.layout();
        this.springConfigPreferncesGroup.layout();
        this.refresh();
    }

    private IStatus checkRuntimeExist(String path) {
        String[] cxfJarFiles;
        File cxfLibFolder;
        File cxfHomeDir = new File(path);
        if (this.cxfHomeDirText.getText().equals("")) {
            this.CXF_LOCATION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_NOT_SET);
        }
        String cxfLibPath = cxfHomeDir + System.getProperty("file.separator") + "lib";
        if (cxfHomeDir.isDirectory() && (cxfLibFolder = new File(cxfLibPath)).isDirectory() && (cxfJarFiles = this.getCXFJarFiles(cxfLibFolder)) != null && cxfJarFiles.length > 0) {
            IStatus toolVersionStatus = this.getToolVersion(cxfLibPath);
            this.processToolVersion(toolVersionStatus);
            this.CXF_LOCATION_STATUS = this.OK_STATUS;
            this.exportCXFClasspathContainerButton.setEnabled(true);
            return this.CXF_LOCATION_STATUS;
        }
        this.context.setCxfRuntimeLocation("");
        this.context.setCxfRuntimeVersion("");
        this.cxfToolVersionLabel.setText("");
        this.exportCXFClasspathContainerButton.setEnabled(false);
        this.CXF_LOCATION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_NOT_SET);
        return this.CXF_LOCATION_STATUS;
    }

    private IStatus getToolVersion(String cxLibFolderPath) {
        String[] jarFiles;
        File cxfLibFolder = new File(cxLibFolderPath);
        ArrayList<String> cxfLib = new ArrayList<String>();
        String[] stringArray = jarFiles = cxfLibFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String jarFile = stringArray[n2];
            cxfLib.add(String.valueOf(cxLibFolderPath) + System.getProperty("file.separator") + jarFile);
            ++n2;
        }
        IStatus toolVersionStatus = LaunchUtils.launch((String[])cxfLib.toArray(new String[cxfLib.size()]), (String)"org.apache.cxf.tools.wsdlto.WSDLToJava", (String[])new String[]{"-v"});
        return toolVersionStatus;
    }

    private String[] getCXFJarFiles(File directory) {
        String[] cxfJarFiles = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("cxf") && name.endsWith(".jar") && CXFRuntimePreferencePage.this.digitPattern.matcher(name).find();
            }
        });
        return cxfJarFiles;
    }

    private void processToolVersion(IStatus toolVersionStatus) {
        if (toolVersionStatus.getSeverity() == 1) {
            String cxfToolVersion = toolVersionStatus.getMessage();
            cxfToolVersion = cxfToolVersion.substring(cxfToolVersion.indexOf("-") + 1, cxfToolVersion.length()).trim();
            String cxfRuntimeEdition = "";
            String cxfRuntimeVersion = "";
            Matcher matcher = this.digitPattern.matcher(cxfToolVersion);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                while (matcher.find()) {
                    end = matcher.end();
                }
                cxfRuntimeEdition = cxfToolVersion.substring(0, start).trim();
                cxfRuntimeVersion = cxfToolVersion.substring(start, end);
            }
            this.cxfToolVersionLabel.setText(String.valueOf(cxfRuntimeEdition) + " " + cxfRuntimeVersion);
            this.context.setCxfRuntimeVersion(cxfRuntimeVersion);
            this.context.setCxfRuntimeEdition(cxfRuntimeEdition);
            CXFCorePlugin.getDefault().setCurrentRuntimeVersion(new Version(cxfRuntimeVersion));
        }
    }

    private void updateStatus() {
        this.CXF_LOCATION_STATUS = this.checkRuntimeExist(this.cxfHomeDirText.getText());
        this.applyStatusToPage(this.findMostSevere());
    }

    private void applyStatusToPage(IStatus status) {
        String message = status.getMessage();
        if (status.getSeverity() > 0) {
            this.setErrorMessage(message);
        } else {
            this.setMessage(this.getTitle());
            this.setErrorMessage(null);
        }
    }

    private IStatus findMostSevere() {
        return this.CXF_LOCATION_STATUS;
    }

    private void setDefaults() {
        this.exportCXFClasspathContainerButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)0, (int)10));
        this.java2WSDLRuntimePreferencesComposite.setDefaults();
        this.java2WSRuntimePreferencesComposite.setDefaults();
        this.cxf20WSDL2JavaPreferencesComposite.setDefaults();
        this.cxf21WSDL2JavaPreferencesComposite.setDefaults();
        this.annotationsComposite.setDefaults();
        this.springConfigComposite.setDefaults();
    }

    private void refresh() {
        if (this.context.getCxfRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSRuntimePreferencesComposite.refresh();
            this.cxf21WSDL2JavaPreferencesComposite.refresh();
        } else {
            this.java2WSDLRuntimePreferencesComposite.refresh();
            this.cxf20WSDL2JavaPreferencesComposite.refresh();
        }
    }

    private void storeValues() {
        this.context.setExportCXFClasspathContainer(this.exportCXFClasspathContainerButton.getSelection());
        if (this.context.getCxfRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSRuntimePreferencesComposite.storeValues();
            this.cxf21WSDL2JavaPreferencesComposite.storeValues();
        } else {
            this.java2WSDLRuntimePreferencesComposite.storeValues();
            this.cxf20WSDL2JavaPreferencesComposite.storeValues();
        }
        this.annotationsComposite.storeValues();
        this.springConfigComposite.storeValues();
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }
}

