/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.WebMethod;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public abstract class AbstractWebMethodPublicStaticFinalRuleTest
extends AbstractAnnotationValidationTest {
    protected Annotation getAnnotation() {
        return AnnotationsCore.createAnnotation((AST)this.ast, WebMethod.class, (String)WebMethod.class.getSimpleName(), null);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyClass\")\n");
        classContents.append("public class MyClass {\n\n");
        classContents.append("\tString myPackagePrivateMethod() {\n\t\treturn \"package-private\";\n\t}\n\n");
        classContents.append("\tprivate String myPrivateMethod() {\n\t\treturn \"private\";\n\t}\n\n");
        classContents.append("\tprotected String myProtectedMethod() {\n\t\tmyPrivateMethod();\n");
        classContents.append("\t\treturn \"protected\";\n\t}\n");
        classContents.append("\tpublic static String myStaticMethod() {\n\t\treturn \"static\";\n\t}\n\n");
        classContents.append("\tpublic final String myFinalMethod() {\n\t\treturn \"final\";\n\t}\n\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "MyClass.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public abstract IMethod getMethodToTeset();

    public abstract String getErrorMessage();

    public void testWebMethodRestriction() {
        try {
            AbstractWebMethodPublicStaticFinalRuleTest.assertNotNull((Object)this.annotation);
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((String)WebMethod.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.getMethodToTeset();
            AbstractWebMethodPublicStaticFinalRuleTest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebMethod.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToMethod((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            AbstractWebMethodPublicStaticFinalRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AbstractWebMethodPublicStaticFinalRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((Object)this.getErrorMessage(), (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

