/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.jws.WebParam;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class AddAnnotationToMethodParameterTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "Calculator.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (Object)"i");
        memberValuePairs.add(nameValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebParam.class, (String)WebParam.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToMethodParameter() {
        try {
            AddAnnotationToMethodParameterTest.assertNotNull((Object)this.annotation);
            AddAnnotationToMethodParameterTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("add", new String[]{"I", "I"});
            AddAnnotationToMethodParameterTest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebParam.class, (TextFileChange)this.textFileChange, (boolean)true);
            SingleVariableDeclaration parameter = AnnotationUtils.getMethodParameter((CompilationUnit)this.compilationUnit, (IMethod)method, (int)65);
            AnnotationUtils.addAnnotationToMethodParameter((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (SingleVariableDeclaration)parameter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            AddAnnotationToMethodParameterTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            parameter = AnnotationUtils.getMethodParameter((CompilationUnit)AnnotationUtils.getASTParser((ICompilationUnit)method.getCompilationUnit(), (boolean)false), (IMethod)method, (int)93);
            AddAnnotationToMethodParameterTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (Annotation)this.annotation));
        }
        catch (CoreException ce) {
            AddAnnotationToMethodParameterTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

