/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.xml.ws.WebServiceRef;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class AddAnnotationToFieldTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        return "package com.example;\n\npublic class MyClass {\n\n\tstatic String service;\n\n}";
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair wsdlLocationValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"wsdlLocation", (Object)"http://localhost:8083/ServiceProject/servives/MyService?WSDL");
        memberValuePairs.add(wsdlLocationValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebServiceRef.class, (String)WebServiceRef.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToField() {
        try {
            AddAnnotationToFieldTest.assertNotNull((Object)this.annotation);
            AddAnnotationToFieldTest.assertEquals((String)WebServiceRef.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IField field = this.source.findPrimaryType().getField("service");
            AddAnnotationToFieldTest.assertNotNull((Object)field);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebServiceRef.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToField((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IField)field, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            AddAnnotationToFieldTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToFieldTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
        }
        catch (CoreException ce) {
            AddAnnotationToFieldTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

