/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.security.core.XmlSecurityPlugin;
import org.eclipse.wst.xml.security.core.utils.Messages;
import org.eclipse.wst.xml.security.core.utils.SignatureNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Utils {
    private static HashSet<String> xpathCollector = new HashSet();
    private static String xpathExpressionToContent = null;
    private static final String TEMPORARY_ELEMENT_LOCAL_NAME = "xmlsectempelement";
    private static final String ID_ATTRIBUTE = "Id";

    private Utils() {
    }

    public static Document parse(IFile file) throws SAXException, IOException, ParserConfigurationException {
        return Utils.prepareDocumentBuilder(true, false).parse(file.getLocationURI().toString());
    }

    public static Document parse(File file) throws SAXException, IOException, ParserConfigurationException {
        return Utils.prepareDocumentBuilder(true, false).parse(file);
    }

    public static Document parse(byte[] content) throws SAXException, IOException, ParserConfigurationException {
        return Utils.prepareDocumentBuilder(true, false).parse(new ByteArrayInputStream(content));
    }

    public static Document parse(InputStream content) throws SAXException, IOException, ParserConfigurationException {
        return Utils.prepareDocumentBuilder(true, false).parse(content);
    }

    public static Document parse(String content) throws SAXException, IOException, ParserConfigurationException {
        StringBuffer xml = new StringBuffer();
        if (!content.startsWith("<") && !content.endsWith(">")) {
            xml.append("<xmlsectempelement>");
            xml.append(content);
            xml.append("</xmlsectempelement>");
        } else {
            xml.append(content);
        }
        return Utils.prepareDocumentBuilder(true, false).parse(new InputSource(new StringReader(xml.toString())));
    }

    public static Document createDocument() throws ParserConfigurationException {
        return Utils.prepareDocumentBuilder(true, false).newDocument();
    }

    private static DocumentBuilder prepareDocumentBuilder(boolean namespaceAware, boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        dbf.setValidating(validating);
        return dbf.newDocumentBuilder();
    }

    public static String[] getIds(InputStream xml, String type) {
        String ids = "Use first " + type + ";";
        try {
            Document doc = Utils.parse(xml);
            Element current = null;
            NodeList nodes = null;
            if ("encryption".equals(type)) {
                nodes = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            } else if ("signature".equals(type)) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                SignatureNamespaceContext ns = new SignatureNamespaceContext();
                xpath.setNamespaceContext(ns);
                nodes = (NodeList)xpath.evaluate("//ds:Signature", doc, XPathConstants.NODESET);
            }
            if (nodes != null) {
                int i = 0;
                int length = nodes.getLength();
                while (i < length) {
                    current = (Element)nodes.item(i);
                    if (current.getAttribute(ID_ATTRIBUTE) != null && current.getAttribute(ID_ATTRIBUTE).trim().length() > 0) {
                        ids = String.valueOf(ids) + current.getAttribute(ID_ATTRIBUTE) + ";";
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            Utils.logError(ex, Messages.errorDuringIdSearch);
        }
        return ids.split(";");
    }

    public static String[] getAllIds(InputStream xml) {
        String ids = "";
        try {
            Document doc = Utils.parse(xml);
            Element current = null;
            NodeList encNodes = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            XPath xpath = XPathFactory.newInstance().newXPath();
            SignatureNamespaceContext ns = new SignatureNamespaceContext();
            xpath.setNamespaceContext(ns);
            NodeList sigNodes = (NodeList)xpath.evaluate("//ds:Signature", doc, XPathConstants.NODESET);
            int i = 0;
            int length = encNodes.getLength();
            while (i < length) {
                current = (Element)encNodes.item(i);
                if (current.getAttribute(ID_ATTRIBUTE) != null && current.getAttribute(ID_ATTRIBUTE).trim().length() > 0) {
                    ids = String.valueOf(ids) + current.getAttribute(ID_ATTRIBUTE) + ";";
                }
                ++i;
            }
            i = 0;
            length = sigNodes.getLength();
            while (i < length) {
                current = (Element)sigNodes.item(i);
                if (current.getAttribute(ID_ATTRIBUTE) != null && current.getAttribute(ID_ATTRIBUTE).trim().length() > 0) {
                    ids = String.valueOf(ids) + current.getAttribute(ID_ATTRIBUTE) + ";";
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Utils.logError(ex, Messages.errorDuringIdSearch);
        }
        return ids.split(";");
    }

    public static Object[] getCompleteXpath(Document doc) {
        Element root = doc.getDocumentElement();
        xpathCollector.add(Utils.getXPathExpression(root));
        Utils.childNodes(root);
        return xpathCollector.toArray();
    }

    private static void childNodes(Node node) {
        NodeList childList = node.getChildNodes();
        Node childNode = null;
        int i = 0;
        int length = childList.getLength();
        while (i < length) {
            childNode = childList.item(i);
            if (childNode.getNodeType() == 1) {
                xpathCollector.add(Utils.getXPathExpression(childNode));
            }
            Utils.childNodes(childNode);
            ++i;
        }
    }

    private static String getXPathExpression(Node node) {
        String xpathExpression = node.getNodeName();
        if (node.getParentNode() != null) {
            int index = 0;
            Node prec = node;
            while (prec != null) {
                if (prec.getNodeName().equals(node.getNodeName())) {
                    ++index;
                }
                prec = prec.getPreviousSibling();
            }
            if (!(node.getParentNode() instanceof Document)) {
                xpathExpression = String.valueOf(Utils.getXPathExpression(node.getParentNode())) + "/" + xpathExpression + "[" + String.valueOf(index) + "]";
            }
        }
        return xpathExpression;
    }

    public static String getUniqueXPathToNode(Document doc, Document selection) {
        String xpathExpression = "/";
        if (!selection.getDocumentElement().getLocalName().equals(TEMPORARY_ELEMENT_LOCAL_NAME)) {
            String selectionRootElement = selection.getDocumentElement().getLocalName();
            xpathExpression = "//" + selectionRootElement;
            NodeList matchingNodes = doc.getElementsByTagName(selectionRootElement);
            if (matchingNodes.getLength() == 1) {
                xpathExpression = Utils.getXPathExpression(matchingNodes.item(0));
            } else {
                int i = 0;
                while (i < matchingNodes.getLength()) {
                    boolean foundNode = true;
                    NodeList selectionChildNodes = selection.getChildNodes();
                    int j = 0;
                    while (j < selectionChildNodes.getLength()) {
                        Node selectionNode = selectionChildNodes.item(j);
                        Node matchingNode = matchingNodes.item(i);
                        if (!matchingNode.toString().equals(selectionNode.toString())) {
                            foundNode = false;
                            break;
                        }
                        if (!matchingNode.getTextContent().trim().equals(selectionNode.getTextContent().trim())) {
                            foundNode = false;
                            break;
                        }
                        ++j;
                    }
                    if (foundNode) {
                        xpathExpression = Utils.getXPathExpression(matchingNodes.item(i));
                        break;
                    }
                    ++i;
                }
            }
        } else {
            xpathExpressionToContent = null;
            xpathExpression = Utils.getXPathToContent(doc.getDocumentElement(), selection.getDocumentElement().getTextContent());
        }
        return xpathExpression;
    }

    private static String getXPathToContent(Node root, String selectedContent) {
        NodeList childList = root.getChildNodes();
        Node childNode = null;
        int i = 0;
        int length = childList.getLength();
        while (i < length && xpathExpressionToContent == null) {
            childNode = childList.item(i);
            if (childNode.getNodeType() == 3 && childNode.getTextContent().equals(selectedContent)) {
                xpathExpressionToContent = Utils.getXPathExpression(childNode.getParentNode());
            }
            Utils.getXPathToContent(childNode, selectedContent);
            ++i;
        }
        return String.valueOf(xpathExpressionToContent) + "/text()";
    }

    public static String validateXPath(Document doc, String xpathExpression) {
        block7: {
            NodeList nodes;
            block5: {
                block6: {
                    try {
                        XPath xpath = XPathFactory.newInstance().newXPath();
                        nodes = (NodeList)xpath.evaluate(xpathExpression, doc, XPathConstants.NODESET);
                        if (nodes.getLength() != 1) break block5;
                        if (nodes.item(0).getNodeType() != 2) break block6;
                        return "attribute";
                    }
                    catch (Exception exception) {
                        return "none";
                    }
                }
                if (nodes.item(0).getNodeType() == 1) {
                    return "single";
                }
                break block7;
            }
            if (nodes.getLength() <= 1) break block7;
            return "multiple";
        }
        return "none";
    }

    public static String docToString(Document doc, boolean prettyPrint) throws Exception {
        DocumentType type;
        StringWriter writer = new StringWriter();
        boolean indentFallback = false;
        TransformerFactory factory = TransformerFactory.newInstance();
        if (prettyPrint) {
            try {
                factory.setAttribute("indent-number", "4");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                indentFallback = true;
            }
        }
        Transformer transformer = factory.newTransformer();
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("standalone", "yes");
        props.setProperty("omit-xml-declaration", "no");
        if (prettyPrint) {
            props.setProperty("indent", "yes");
            if (indentFallback) {
                props.setProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            }
        }
        if ((type = doc.getDoctype()) != null) {
            String systemId;
            String publicId = type.getPublicId();
            if (publicId != null) {
                props.setProperty("doctype-public", publicId);
            }
            if ((systemId = type.getSystemId()) != null) {
                props.setProperty("doctype-system", systemId);
            }
        }
        transformer.setOutputProperties(props);
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    public static boolean validateId(String id) {
        return Pattern.matches("[^<>&\"'\\s]+", id);
    }

    public static boolean ensureIdIsUnique(String newId, String[] ids) {
        boolean uniqueId = true;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String currentId = stringArray[n2];
            if (currentId.equals(newId)) {
                uniqueId = false;
            }
            ++n2;
        }
        return uniqueId;
    }

    public static boolean parseSelection(String textSelection) {
        if (textSelection == null || textSelection.trim().length() == 0) {
            return false;
        }
        Pattern p = Pattern.compile("[^<>]+");
        Matcher m = p.matcher(textSelection);
        if (!m.matches()) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            try {
                XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                xmlReader.setErrorHandler(null);
                xmlReader.parse(new InputSource(new StringReader(textSelection)));
            }
            catch (IOException ex) {
                Utils.logError(ex, "Error during parsing textselection");
                return false;
            }
            catch (SAXException ex) {
                Utils.logError(ex, "Error during parsing textselection");
                return false;
            }
            catch (ParserConfigurationException ex) {
                Utils.logError(ex, "Error during parsing textselection");
                return false;
            }
            return true;
        }
        return true;
    }

    public static void logError(Exception ex, String message) {
        Status status = new Status(4, XmlSecurityPlugin.getDefault().getBundle().getSymbolicName(), 0, message, (Throwable)ex);
        XmlSecurityPlugin.getDefault().getLog().log((IStatus)status);
    }
}

