/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.verify;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.eclipse.wst.xml.security.core.utils.SignatureNamespaceContext;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifySignature {
    public ArrayList<VerificationResult> verify(String signatureFileName, String signatureId) throws Exception {
        ArrayList<VerificationResult> signatures = new ArrayList<VerificationResult>();
        XMLSignature signature = null;
        KeyInfo keyInfo = null;
        boolean schemaValidate = false;
        File file = new File(signatureFileName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (schemaValidate) {
            dbf.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
            dbf.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.TRUE);
            dbf.setValidating(true);
            dbf.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
        }
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        if (schemaValidate) {
            dbf.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.w3.org/2000/09/xmldsig# data/xmldsig-core-schema.xsd");
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        if (schemaValidate) {
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    if (systemId.endsWith("xmldsig-core-schema.xsd")) {
                        try {
                            return new InputSource(new FileInputStream("data/xmldsig-core-schema.xsd"));
                        }
                        catch (FileNotFoundException ex) {
                            throw new SAXException(ex);
                        }
                    }
                    return null;
                }
            });
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        SignatureNamespaceContext ns = new SignatureNamespaceContext();
        InputSource inputSource = new InputSource(new FileInputStream(file));
        xpath.setNamespaceContext(ns);
        Element signatureElement = (Element)xpath.evaluate("//ds:Signature[@Id='" + signatureId + "']", inputSource, XPathConstants.NODE);
        String status = "";
        String type = "";
        String algorithm = "";
        try {
            if (signatureElement != null) {
                signature = new XMLSignature(signatureElement, file.toURI().toString());
                keyInfo = signature.getKeyInfo();
                if (keyInfo != null) {
                    X509Certificate cert = keyInfo.getX509Certificate();
                    PublicKey pk = keyInfo.getPublicKey();
                    if (cert != null) {
                        type = cert.getType();
                        algorithm = cert.getSigAlgName();
                        status = signature.checkSignatureValue(cert) ? "valid" : "invalid";
                    } else if (pk != null) {
                        type = "";
                        algorithm = pk.getAlgorithm();
                        status = signature.checkSignatureValue((Key)pk) ? "valid" : "invalid";
                    } else {
                        status = "unknown";
                    }
                } else {
                    status = "unknown";
                }
                signatures.add(new VerificationResult(status, signatureId, type, algorithm, signature));
            } else {
                signatures.add(new VerificationResult("unknown", signatureId, type, algorithm, signature));
            }
        }
        catch (Exception ex) {
            signatures.add(new VerificationResult("unknown", signatureId, type, algorithm, signature));
            Utils.logError(ex, "Error during single signature verification");
        }
        return signatures;
    }
}

