/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.decrypt;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.security.core.decrypt.Decryption;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.decrypt.Messages;
import org.eclipse.wst.xml.security.ui.decrypt.PageResource;

public class NewDecryptionWizard
extends Wizard
implements INewWizard {
    private PageResource pageResource = null;
    private IFile xmlDocument;
    private Decryption decryption = new Decryption();
    public static final String SETTING_KEYSTORE = "dec_keystore";
    public static final String SETTING_KEY_NAME = "dec_key_name";

    public NewDecryptionWizard() {
        this.setWindowTitle(Messages.decryptionWizard);
        this.setDialogSettings(this.getDecryptionWizardSettings());
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)XSTUIPlugin.getId(), (String)"icons/wiz_dec.gif");
        this.setDefaultPageImageDescriptor(image);
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getDecryptionWizardSettings() {
        IDialogSettings workbenchSettings = XSTUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("DecryptionWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("DecryptionWizard");
        }
        return section;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void init(IFile file) {
        this.xmlDocument = file;
    }

    public void addPages() {
        this.pageResource = new PageResource(this.decryption, this.xmlDocument);
        this.addPage((IWizardPage)this.pageResource);
    }

    public boolean canFinish() {
        return this.pageResource.isPageComplete();
    }

    public boolean performFinish() {
        return true;
    }

    public Decryption getModel() {
        return this.decryption;
    }
}

