/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.tests.sign;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.CreateSignature;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.tests.XMLSecurityToolsCoreTestPlugin;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.eclipse.wst.xml.security.core.verify.VerifySignature;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreateSignatureTest
extends TestCase {
    private Signature signature = null;
    private static final String SIGNATURE_ID = "JUnitTest";
    private static final String SIGNED_FILE_NAME = "result.xml";
    private static final String KEYSTORE_PATH = "resources/sample_keystore.jks";
    private static final String KEYSTORE_PASSWORD = "sampleKeystore";
    private static final String KEY_ALIAS = "sampleKey";
    private static final String KEY_PASSWORD = "sampleKey";

    protected void setUp() throws Exception {
        Init.init();
        Keystore sampleKeyStore = new Keystore(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(KEYSTORE_PATH), KEYSTORE_PASSWORD, "JCEKS");
        sampleKeyStore.load();
        this.signature = new Signature();
        this.signature.setBsp(false);
        this.signature.setLaunchEncryptionWizard(false);
        this.signature.setCanonicalizationAlgorithm("Exclusive with comments");
        this.signature.setKeyName("sampleKey");
        this.signature.setKeyPassword("sampleKey".toCharArray());
        this.signature.setDetachedFile(null);
        this.signature.setFile(XMLSecurityToolsCoreTestPlugin.getTestFileLocation("resources/FirstSteps.xml"));
        this.signature.setKeystore(sampleKeyStore);
        this.signature.setKeystorePassword(KEYSTORE_PASSWORD.toCharArray());
        this.signature.setMessageDigestAlgorithm("SHA 1");
        this.signature.setResource("document");
        this.signature.setSignatureAlgorithm("DSA with SHA 1 (DSS)");
        this.signature.setSignatureId(SIGNATURE_ID);
        this.signature.setSignatureProperties(null);
        this.signature.setSignatureType("enveloped");
        this.signature.setTransformationAlgorithm("None");
        this.signature.setXpath(null);
    }

    public void tearDown() throws Exception {
        this.signature = null;
        try {
            File file = new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation(SIGNED_FILE_NAME));
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void testSign() {
        CreateSignature sign = new CreateSignature();
        VerifySignature verify = new VerifySignature();
        Document result = null;
        try {
            result = sign.sign(this.signature, null, null);
            String signedFilename = XMLSecurityToolsCoreTestPlugin.getTestFileLocation(SIGNED_FILE_NAME);
            FileOutputStream fos = new FileOutputStream(signedFilename);
            if (result != null) {
                XMLUtils.outputDOM((Node)result, (OutputStream)fos);
            }
            fos.flush();
            fos.close();
            ArrayList signatures = verify.verify(signedFilename, SIGNATURE_ID);
            CreateSignatureTest.assertEquals((String)"valid", (String)((VerificationResult)signatures.get(0)).getStatus());
            signatures = verify.verify(signedFilename, "wrongID");
            CreateSignatureTest.assertEquals((String)"unknown", (String)((VerificationResult)signatures.get(0)).getStatus());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CreateSignatureTest.fail((String)ex.getLocalizedMessage());
        }
    }
}

