/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.tests.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.wst.xml.security.core.tests.XMLSecurityToolsCoreTestPlugin;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.w3c.dom.Document;

public class UtilsTest
extends TestCase {
    private Document xml = null;
    private Document selection = null;

    public void setUp() throws Exception {
        this.xml = Utils.parse((File)new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation("resources/FirstSteps.xml")));
    }

    public void testGetUniqueXPathToNode() throws Exception {
        this.selection = Utils.parse((String)"<Quantity>1</Quantity>");
        UtilsTest.assertEquals((String)"Invoice/InvoiceLine[2]/Quantity[1]", (String)Utils.getUniqueXPathToNode((Document)this.xml, (Document)this.selection));
        this.selection = Utils.parse((String)"<PaymentMeans><PayeeFinancialAccount><ID>07044961</ID><Name>The Specialists Company</Name><AccountTypeCode>Credit</AccountTypeCode><FinancialInstitutionBranch><ID>776631</ID><Institution>LOYDGB852</Institution></FinancialInstitutionBranch></PayeeFinancialAccount></PaymentMeans>");
        UtilsTest.assertEquals((String)"Invoice/PaymentMeans[1]", (String)Utils.getUniqueXPathToNode((Document)this.xml, (Document)this.selection));
        this.selection = Utils.parse((String)"<xmlsectempelement>458746</xmlsectempelement>");
        UtilsTest.assertEquals((String)"Invoice/BuyerParty[1]/ID[1]/text()", (String)Utils.getUniqueXPathToNode((Document)this.xml, (Document)this.selection));
    }

    public void testGetIds() throws Exception {
        FileInputStream idStream = new FileInputStream(new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation("resources/ids.xml")));
        String[] idsEncryption = new String[]{"Use first encryption id", "myEncryptionA", "myEncryptionB"};
        UtilsTest.assertEquals((int)idsEncryption.length, (int)Utils.getIds((InputStream)idStream, (String)"encryption").length);
        idStream = new FileInputStream(new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation("resources/ids.xml")));
        String[] idsSignature = new String[]{"Use first signature id", "mySignature"};
        UtilsTest.assertEquals((int)idsSignature.length, (int)Utils.getIds((InputStream)idStream, (String)"signature").length);
    }

    public void testGetAllIds() throws Exception {
        FileInputStream idStream = new FileInputStream(new File(XMLSecurityToolsCoreTestPlugin.getTestFileLocation("resources/ids.xml")));
        String[] ids = new String[]{"myEncryptionA", "myEncryptionB", "mySignature"};
        UtilsTest.assertEquals((int)ids.length, (int)Utils.getAllIds((InputStream)idStream).length);
    }

    public void testValidateXPath() {
        UtilsTest.assertEquals((String)"attribute", (String)Utils.validateXPath((Document)this.xml, (String)"Invoice/TotalAmount/@currencyID"));
        UtilsTest.assertEquals((String)"single", (String)Utils.validateXPath((Document)this.xml, (String)"Invoice/InvoiceLine[1]/Item/BasePrice[@currencyID='EUR']"));
        UtilsTest.assertEquals((String)"multiple", (String)Utils.validateXPath((Document)this.xml, (String)"Invoice/InvoiceLine"));
        UtilsTest.assertEquals((String)"none", (String)Utils.validateXPath((Document)this.xml, (String)"Invoice/Line"));
    }

    public void testValidateId() {
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.validateId((String)"valid"));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)"aa<324 "));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)">"));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)"\""));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)"'"));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)"&"));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.validateId((String)" "));
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.validateId((String)"\u00c3\u00a4\u00c3\u00b6\u00c3\u00bc\u00c3\u009f$%/()"));
    }

    public void testCheckIdUniqueness() {
        String[] ids = new String[]{"myID", "myid", "aaa", "bbb", "x", "\u00c3\u00b6\u00c3\u00a4\u00c3\u00bc"};
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.ensureIdIsUnique((String)"aa", (String[])ids));
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.ensureIdIsUnique((String)"mySignatureID", (String[])ids));
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.ensureIdIsUnique((String)"\u00c3\u00a4\u00c3\u00b6\u00c3\u00bc\u00c3\u009f", (String[])ids));
        UtilsTest.assertEquals((boolean)true, (boolean)Utils.ensureIdIsUnique((String)"myId", (String[])ids));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.ensureIdIsUnique((String)"myid", (String[])ids));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.ensureIdIsUnique((String)"\u00c3\u00b6\u00c3\u00a4\u00c3\u00bc", (String[])ids));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.ensureIdIsUnique((String)"x", (String[])ids));
        UtilsTest.assertEquals((boolean)false, (boolean)Utils.ensureIdIsUnique((String)"bbb", (String[])ids));
    }
}

