/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.encrypt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.SignatureNamespaceContext;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.core.utils.XmlSecurityConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateEncryption {
    private File xmlFile = null;
    private File detachedFile = null;
    private Document detachedDoc = null;
    private boolean encryptContentOnly;
    private String encryptionType = null;
    private Keystore keystore = null;
    private String resource = null;
    private String expression = null;
    private String encryptionId = null;
    private String encryptionAlgorithm = null;
    private String keyCipherAlgorithm = null;
    private String keyName = "";

    public Document encrypt(Encryption encryption, String selection, IProgressMonitor monitor) throws Exception {
        Document doc = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.worked(1);
        this.loadSettings(encryption, selection);
        this.keystore.load();
        SecretKey key = this.keystore.getSecretKey(encryption.getKeyName(), encryption.getKeyPassword());
        if (key == null) {
            throw new Exception("Key " + this.keyName + " not found in keystore " + this.keystore);
        }
        monitor.worked(1);
        if (this.encryptionType.equalsIgnoreCase("enveloping")) {
            doc = this.envelopingEncryption(this.xmlFile, selection, key);
        } else if (this.encryptionType.equalsIgnoreCase("detached")) {
            doc = this.detachedEncryption(this.xmlFile, key);
        }
        monitor.worked(1);
        return doc;
    }

    private void loadSettings(Encryption encryption, String selection) throws Exception {
        this.xmlFile = new File(encryption.getFile());
        this.encryptionType = encryption.getEncryptionType();
        this.encryptContentOnly = encryption.getContent();
        this.keystore = encryption.getKeystore();
        this.keyName = encryption.getKeyName();
        this.resource = encryption.getResource();
        this.expression = encryption.getXpath();
        this.detachedFile = encryption.getFileDetached();
        if (this.detachedFile != null) {
            this.detachedDoc = Utils.parse(this.detachedFile);
        }
        if (encryption.getEncryptionId() != null) {
            this.encryptionId = encryption.getEncryptionId();
        }
        this.encryptionAlgorithm = XmlSecurityConstants.getEncryptionAlgorithm(encryption.getEncryptionAlgorithm());
        this.keyCipherAlgorithm = XmlSecurityConstants.getKeyCipherAlgorithm(encryption.getKeyWrapAlogrithm());
    }

    private Document envelopingEncryption(File file, String selection, Key secretKey) throws Exception {
        Document doc = Utils.parse(this.xmlFile);
        Element root = doc.getDocumentElement();
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.keyCipherAlgorithm);
        keyCipher.init(3, secretKey);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.encryptionAlgorithm);
        xmlCipher.init(1, secretKey);
        EncryptedKey encryptedKey = keyCipher.encryptKey(doc, secretKey);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.addKeyName(this.keyName);
        keyInfo.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo);
        if (!"".equals(this.encryptionId)) {
            encryptedData.setId(this.encryptionId);
        }
        if ("document".equalsIgnoreCase(this.resource)) {
            xmlCipher.doFinal(doc, root, this.encryptContentOnly);
        } else if ("selection".equalsIgnoreCase(this.resource)) {
            Document selectionDoc = Utils.parse(selection);
            String tempXPath = Utils.getUniqueXPathToNode(doc, selectionDoc);
            XPath xpath = XPathFactory.newInstance().newXPath();
            SignatureNamespaceContext ns = new SignatureNamespaceContext();
            xpath.setNamespaceContext(ns);
            Element selectedElement = (Element)xpath.evaluate(tempXPath, doc, XPathConstants.NODE);
            xmlCipher.doFinal(doc, selectedElement, this.encryptContentOnly);
        } else if ("xpath".equalsIgnoreCase(this.resource)) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            SignatureNamespaceContext ns = new SignatureNamespaceContext();
            xpath.setNamespaceContext(ns);
            Element selectedElement = (Element)xpath.evaluate(this.expression, doc, XPathConstants.NODE);
            xmlCipher.doFinal(doc, selectedElement, this.encryptContentOnly);
        }
        return doc;
    }

    private Document detachedEncryption(File file, Key secretKey) throws Exception {
        Document contextDoc = Utils.parse(this.xmlFile);
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.keyCipherAlgorithm);
        keyCipher.init(3, secretKey);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.encryptionAlgorithm);
        xmlCipher.init(1, secretKey);
        if ("document".equalsIgnoreCase(this.resource)) {
            XMLCipher contextCipher = XMLCipher.getInstance();
            Element contextRoot = contextDoc.getDocumentElement();
            EncryptedKey encryptedKey = keyCipher.encryptKey(contextDoc, secretKey);
            EncryptedData encryptedData = contextCipher.createEncryptedData(2, this.detachedFile.toURI().toString());
            KeyInfo keyInfo = new KeyInfo(contextDoc);
            keyInfo.addKeyName(this.keyName);
            keyInfo.add(encryptedKey);
            encryptedData.setKeyInfo(keyInfo);
            EncryptionMethod em = contextCipher.createEncryptionMethod(this.encryptionAlgorithm);
            encryptedData.setEncryptionMethod(em);
            if (!"".equals(this.encryptionId)) {
                encryptedData.setId(this.encryptionId);
            }
            Element contextEncryption = contextCipher.martial(contextDoc, encryptedData);
            contextRoot.appendChild(contextEncryption);
            Document enc = xmlCipher.doFinal(this.detachedDoc, this.detachedDoc.getDocumentElement());
            NodeList encrypted = enc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
            String encryptedContent = "";
            if (encrypted.getLength() > 0) {
                encryptedContent = encrypted.item(0).getTextContent();
            }
            if (!"".equals(encryptedContent)) {
                Document encryptedDoc = Utils.createDocument();
                Element docElement = encryptedDoc.createElement("EncryptedDoc");
                docElement.setTextContent(encryptedContent);
                encryptedDoc.appendChild(docElement);
                FileOutputStream fosSource = new FileOutputStream(this.detachedFile);
                XMLUtils.outputDOM((Node)encryptedDoc, (OutputStream)fosSource);
                fosSource.flush();
                fosSource.close();
            }
        }
        return contextDoc;
    }
}

