/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.CreateSignature;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.dialogs.MissingPreferenceDialog;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class QuickSignatureCommand
extends AbstractHandler {
    private IFile file = null;
    private String resource;
    private String xpath = "";
    private String signatureType;
    private Keystore keystore;
    private String keyFile;
    private char[] keystorePassword;
    private String keyName;
    private char[] keyPassword;
    private String canonicalizationAlgorithm;
    private String transformationAlgorithm;
    private String messageDigestAlgorithm;
    private String signatureAlgorithm;
    private String signatureId;
    private boolean completePrefs = false;
    private ExecutionEvent event;
    private ITextSelection textSelection = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            this.createSignature();
        }
        return null;
    }

    private void createSignature() {
        IDocument document = null;
        if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            this.textSelection = (ITextSelection)((ITextEditor)editorPart.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
            this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            document = (IDocument)editorPart.getAdapter(IDocument.class);
        } else {
            this.textSelection = null;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (selection instanceof IStructuredSelection) {
                this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
            }
        }
        PasswordDialog keystorePasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickSignatureCommand_4, Messages.QuickSignatureCommand_1, "");
        if (keystorePasswordDialog.open() != 0) {
            return;
        }
        this.keystorePassword = keystorePasswordDialog.getValue().toCharArray();
        PasswordDialog privateKeyPasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickSignatureCommand_4, Messages.QuickSignatureCommand_3, "");
        if (privateKeyPasswordDialog.open() != 0) {
            return;
        }
        this.keyPassword = privateKeyPasswordDialog.getValue().toCharArray();
        if (this.checkPasswords()) {
            try {
                if (this.loadKeystore()) {
                    if (this.file != null && this.file.isAccessible()) {
                        this.signData(document);
                    } else {
                        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickSignatureCommand_4, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.QuickSignatureCommand_5));
                    }
                } else {
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickSignatureCommand_4, (String)Messages.QuickSignatureCommand_6);
                }
            }
            catch (SAXParseException spe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickSignatureCommand_4, Messages.QuickSignatureCommand_7, spe);
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickSignatureCommand_4, (String)Messages.QuickSignatureCommand_8);
            }
            catch (IOException ioe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickSignatureCommand_4, Messages.QuickSignatureCommand_9, ioe);
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickSignatureCommand_4, Messages.QuickSignatureCommand_10, ex);
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick signing", ex);
            }
        }
    }

    private void signData(final IDocument document) {
        final CreateSignature signature = new CreateSignature();
        final Signature data = new Signature();
        data.setResource(this.resource);
        data.setXpath(this.xpath);
        data.setSignatureType(this.signatureType);
        data.setBsp(false);
        data.setKeystore(this.keystore);
        data.setKeyName(this.keyName);
        data.setKeystorePassword(this.keystorePassword);
        data.setKeyPassword(this.keyPassword);
        data.setCanonicalizationAlgorithm(this.canonicalizationAlgorithm);
        data.setTransformationAlgorithm(this.transformationAlgorithm);
        data.setMessageDigestAlgorithm(this.messageDigestAlgorithm);
        data.setSignatureAlgorithm(this.signatureAlgorithm);
        data.setSignatureId(this.signatureId);
        data.setFile(this.file.getLocation().toOSString());
        Job job = new Job(Messages.QuickSignatureCommand_4){

            public IStatus run(IProgressMonitor monitor) {
                block8: {
                    try {
                        monitor.beginTask(Messages.NewSignatureCommand_7, 5);
                        Document doc = null;
                        doc = QuickSignatureCommand.this.textSelection != null ? signature.sign(data, QuickSignatureCommand.this.textSelection.getText(), monitor) : signature.sign(data, null, monitor);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            if (doc == null) break block8;
                            if (document != null) {
                                document.set(Utils.docToString((Document)doc, (boolean)false));
                                break block8;
                            }
                            FileOutputStream fos = new FileOutputStream(QuickSignatureCommand.this.file.getLocation().toOSString());
                            XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception ex) {
                            HandlerUtil.getActiveShell((ExecutionEvent)QuickSignatureCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)QuickSignatureCommand.this.event), Messages.QuickSignatureCommand_4, Messages.NewSignatureCommand_8, ex);
                                    org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during signing", ex);
                                }
                            });
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean loadKeystore() throws Exception {
        block3: {
            try {
                this.keystore = new Keystore(this.keyFile, this.keystorePassword.toString(), "JCEKS");
                this.keystore.load();
                if (this.keystore.containsKey(this.keyName)) break block3;
                return false;
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick signing", ex);
                return false;
            }
        }
        return this.keystore.getPrivateKey(this.keyName, this.keyPassword) != null;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.resource = store.getString("signatureResource");
        if (this.resource != null && this.resource.equals("xpath")) {
            this.xpath = store.getString("signatureXPath");
        }
        this.signatureType = store.getString("signatureType");
        this.keyFile = store.getString("signatureKeystoreFile");
        this.keyName = store.getString("signatureKeyName");
        this.canonicalizationAlgorithm = store.getString("signatureCanonicalization");
        this.transformationAlgorithm = store.getString("signatureTransformation");
        this.messageDigestAlgorithm = store.getString("signatureMDA");
        this.signatureAlgorithm = store.getString("signatureAlgorithm");
        this.signatureId = store.getString("signatureID");
    }

    private boolean checkPreferences() {
        String title = Messages.QuickSignatureCommand_4;
        int result = 2;
        if (this.resource == null || "".equals(this.resource)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_11), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.resource != null && "xpath".equals(this.resource) && (this.xpath == null || "".equals(this.xpath))) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_12), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.signatureType == null || "".equals(this.signatureType)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_13), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.keyFile == null || "".equals(this.keyFile)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_14), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.keyName == null || "".equals(this.keyName)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_15), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.canonicalizationAlgorithm == null || "".equals(this.canonicalizationAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_16), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.transformationAlgorithm != null && "".equals(this.transformationAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_17), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.messageDigestAlgorithm == null || "".equals(this.messageDigestAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_18), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.signatureAlgorithm == null || "".equals(this.signatureAlgorithm)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickSignatureCommand_19), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else if (this.signatureId == null || "".equals(this.signatureId)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.MissingSignatureId), "org.eclipse.wst.xml.security.ui.preferences.Signature");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }

    private boolean checkPasswords() {
        if (this.keystorePassword == null || this.keystorePassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickSignatureCommand_4, (String)Messages.QuickSignatureCommand_1);
            return false;
        }
        if (this.keyPassword == null || this.keyPassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickSignatureCommand_4, (String)Messages.QuickSignatureCommand_3);
            return false;
        }
        return true;
    }

    private int showMissingParameterDialog(String title, String message, String prefId) {
        MissingPreferenceDialog dialog = new MissingPreferenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), title, message, prefId);
        return dialog.open();
    }
}

