/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.utils;

public final class XmlSecurityConstants {
    public static String getSignatureAlgorithm(String signatureAlgorithmString) {
        if (signatureAlgorithmString.equalsIgnoreCase("DSA with SHA 1 (DSS)")) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("Elliptic Curve DSA (ECDSA)")) {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with MD5")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA")) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with RIPEMD160")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with SHA 1")) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with SHA 256")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with SHA 384")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
        if (signatureAlgorithmString.equalsIgnoreCase("RSA with SHA 512")) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
        return null;
    }

    public static String getMessageDigestAlgorithm(String messageDigestAlgorithmString) {
        if (messageDigestAlgorithmString.equalsIgnoreCase("MD5")) {
            return "http://www.w3.org/2001/04/xmldsig-more#md5";
        }
        if (messageDigestAlgorithmString.equalsIgnoreCase("RIPEMD 160")) {
            return "http://www.w3.org/2001/04/xmlenc#ripemd160";
        }
        if (messageDigestAlgorithmString.equalsIgnoreCase("SHA 1")) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if (messageDigestAlgorithmString.equalsIgnoreCase("SHA 256")) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if (messageDigestAlgorithmString.equalsIgnoreCase("SHA 384")) {
            return "http://www.w3.org/2001/04/xmldsig-more#sha384";
        }
        if (messageDigestAlgorithmString.equalsIgnoreCase("SHA 512")) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        return null;
    }

    public static String getCanonicalizationAlgorithm(String canonicalizationAlgorithmString) {
        if (canonicalizationAlgorithmString.equalsIgnoreCase("Exclusive without comments")) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        if (canonicalizationAlgorithmString.equalsIgnoreCase("Exclusive with comments")) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        }
        if (canonicalizationAlgorithmString.equalsIgnoreCase("Inclusive without comments")) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        if (canonicalizationAlgorithmString.equalsIgnoreCase("Inclusive with comments")) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        }
        return null;
    }

    public static String getTransformationAlgorithm(String transformationAlgorithmString) {
        if (transformationAlgorithmString.equalsIgnoreCase("Base64")) {
            return "http://www.w3.org/2000/09/xmldsig#base64";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("Enveloped Signature")) {
            return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("Exclusive without comments")) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("Exclusive with comments")) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("Inclusive without comments")) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("Inclusive with comments")) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XPath")) {
            return "http://www.w3.org/TR/1999/REC-xpath-19991116";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XPath 2 Filter")) {
            return "http://www.w3.org/2002/06/xmldsig-filter2";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XPath 2 Filter 04")) {
            return "http://www.w3.org/2002/04/xmldsig-filter2";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XPath Filter CHGP")) {
            return "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XPointer")) {
            return "http://www.w3.org/TR/2001/WD-xptr-20010108";
        }
        if (transformationAlgorithmString.equalsIgnoreCase("XSLT")) {
            return "http://www.w3.org/TR/1999/REC-xslt-19991116";
        }
        return null;
    }

    public static String getEncryptionAlgorithm(String encryptionAlgorithmString) {
        if (encryptionAlgorithmString.equalsIgnoreCase("AES 128")) {
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        if (encryptionAlgorithmString.equalsIgnoreCase("AES 192")) {
            return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
        }
        if (encryptionAlgorithmString.equalsIgnoreCase("AES 256")) {
            return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
        }
        if (encryptionAlgorithmString.equalsIgnoreCase("Triple DES")) {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
        return null;
    }

    public static String getKeyCipherAlgorithm(String keyCipherAlgorithmString) {
        if (keyCipherAlgorithmString.equalsIgnoreCase("AES-128 Key Wrap")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
        if (keyCipherAlgorithmString.equalsIgnoreCase("AES-192 Key Wrap")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        }
        if (keyCipherAlgorithmString.equalsIgnoreCase("AES-256 Key Wrap")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }
        if (keyCipherAlgorithmString.equalsIgnoreCase("Triple DES Key Wrap")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        if (keyCipherAlgorithmString.equalsIgnoreCase("RSA OAEP")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }
        if (keyCipherAlgorithmString.equalsIgnoreCase("RSA 1.5")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        return null;
    }

    public static String getKeyAlgoritm(String keyAlgorithm) {
        if (keyAlgorithm.equalsIgnoreCase("AES")) {
            return "AES";
        }
        if (keyAlgorithm.equalsIgnoreCase("Blowfish")) {
            return "Blowfish";
        }
        if (keyAlgorithm.equalsIgnoreCase("DES")) {
            return "DES";
        }
        if (keyAlgorithm.equalsIgnoreCase("Triple DES")) {
            return "DESede";
        }
        return null;
    }
}

