/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.security.core.canonicalize.Canonicalization;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.utils.Utils;

public class NewCanonicalizationRemoveCommand
extends AbstractHandler {
    private String canonVersion;
    private String canonTarget;
    private IFile file = null;
    private ExecutionEvent event;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.getPreferenceValues();
        this.createCanonicalization();
        return null;
    }

    private void createCanonicalization() {
        try {
            IDocument document = null;
            if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
                final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
                if (editorPart.isDirty()) {
                    if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                        IRunnableWithProgress op = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                editorPart.doSave(monitor);
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        }
                        catch (InvocationTargetException ite) {
                            Utils.log("Error while saving editor content", ite);
                        }
                        catch (InterruptedException ie) {
                            Utils.log("Error while saving editor content", ie);
                        }
                    } else {
                        editorPart.doSaveAs();
                    }
                }
                this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                document = (IDocument)editorPart.getAdapter(IDocument.class);
            } else {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                if (selection instanceof IStructuredSelection) {
                    this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
                }
            }
            if (this.file != null) {
                byte[] outputBytes = this.canonicalize(this.file.getContents());
                if (document != null) {
                    if ("internal".equals(this.canonTarget)) {
                        document.set(new String(outputBytes, "UTF8"));
                    } else {
                        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event).getActivePage();
                        if (page != null) {
                            IFile newFile = this.saveCanonicalizedFile(this.getCanonicalizedPath(), outputBytes);
                            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(newFile.getName());
                            page.openEditor((IEditorInput)new FileEditorInput(newFile), desc.getId());
                        }
                    }
                } else if ("internal".equals(this.canonTarget)) {
                    this.saveCanonicalizedFile(this.file.getLocation(), outputBytes);
                } else {
                    this.saveCanonicalizedFile(this.getCanonicalizedPath(), outputBytes);
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.XMLCanonicalization, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.NewCanonicalizationRemoveCommand_0));
            }
        }
        catch (Exception ex) {
            Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.XMLCanonicalization, Messages.ErrorDuringCanonicalization, ex);
            Utils.log("An error occured during canonicalization", ex);
        }
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.canonVersion = store.getString("canonType");
        this.canonTarget = store.getString("canonTarget");
    }

    private IPath getCanonicalizedPath() {
        IPath path = this.file.getLocation().removeFileExtension();
        String filename = path.lastSegment();
        path = path.removeLastSegments(1);
        if (filename.endsWith("_canon")) {
            filename = String.valueOf(filename) + "[2].xml";
        } else if (filename.contains("_canon[")) {
            int canonNumber = Integer.parseInt(filename.substring(filename.indexOf("[") + 1, filename.indexOf("]")));
            filename = String.valueOf(filename.substring(0, filename.indexOf("[") + 1)) + (canonNumber + 1) + "].xml";
        } else {
            filename = String.valueOf(filename) + "_canon.xml";
        }
        path = path.append(filename);
        return path;
    }

    private IFile saveCanonicalizedFile(IPath newFilePath, byte[] outputBytes) throws Exception {
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(newFilePath);
        if (newFile.exists()) {
            newFile.setContents((InputStream)new ByteArrayInputStream(outputBytes), true, true, null);
        } else {
            newFile.create((InputStream)new ByteArrayInputStream(outputBytes), true, null);
        }
        return newFile;
    }

    private byte[] canonicalize(InputStream stream) throws Exception {
        Canonicalization canonicalization = new Canonicalization();
        return canonicalization.canonicalize(stream, this.getCanonicalizationAlgorithm());
    }

    private String getCanonicalizationAlgorithm() {
        String algorithm = "";
        algorithm = "exclusive".equals(this.canonVersion) ? "http://www.w3.org/2001/10/xml-exc-c14n#" : "http://www.w3.org/2006/12/xml-c14n11";
        return algorithm;
    }
}

