/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.security.core.verify.VerifyDocument;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.utils.Utils;
import org.eclipse.wst.xml.security.ui.verify.SignatureView;

public class NewVerificationCommand
extends AbstractHandler {
    private ExecutionEvent event;
    private IFile file = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.createVerification();
        return null;
    }

    private void createVerification() {
        VerifyDocument verify = new VerifyDocument();
        ArrayList results = new ArrayList();
        if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
        } else {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (selection instanceof IStructuredSelection) {
                this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
            }
        }
        try {
            IViewPart vp;
            if (this.file != null && this.file.isAccessible()) {
                results = verify.verify(this.file.getLocation().toString());
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewVerificationCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.NewVerificationCommand_5));
            }
            if (results.size() == 0) {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewVerificationCommand_0, (String)Messages.NewVerificationCommand_1);
            }
            if ((vp = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event).getActivePage().showView("org.eclipse.wst.xml.security.ui.SignatureView")) instanceof SignatureView) {
                ((SignatureView)vp).setInput(results);
            }
        }
        catch (XMLSignatureException xmlse) {
            Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewVerificationCommand_0, Messages.NewVerificationCommand_2, (Exception)((Object)xmlse));
        }
        catch (KeyResolverException kre) {
            Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewVerificationCommand_0, Messages.NewVerificationCommand_3, (Exception)((Object)kre));
        }
        catch (Exception ex) {
            Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewVerificationCommand_0, Messages.NewVerificationCommand_4, ex);
            Utils.log("An error occured during verification", ex);
        }
    }
}

