/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.eclipse.wst.xml.security.core.verify.VerifySignature;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.dialogs.MissingPreferenceDialog;
import org.eclipse.wst.xml.security.ui.utils.Utils;
import org.eclipse.wst.xml.security.ui.verify.Verification;

public class QuickVerificationCommand
extends AbstractHandler {
    private String signatureId;
    private boolean preferencesComplete = false;
    private ExecutionEvent event;
    private IFile file = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            try {
                this.createVerification();
            }
            catch (XMLSignatureException xmlse) {
                Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.QuickVerificationCommand_0, Messages.QuickVerificationCommand_1, (Exception)((Object)xmlse));
            }
            catch (KeyResolverException kre) {
                Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.QuickVerificationCommand_0, Messages.QuickVerificationCommand_2, (Exception)((Object)kre));
            }
            catch (Exception ex) {
                Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.QuickVerificationCommand_0, Messages.QuickVerificationCommand_3, ex);
                Utils.log("An error occured during quick verification", ex);
            }
        }
        return null;
    }

    private void createVerification() throws Exception {
        VerifySignature verify = new VerifySignature();
        ArrayList results = new ArrayList();
        if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
        } else {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (selection instanceof IStructuredSelection) {
                this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
            }
        }
        if (this.file != null && this.file.isAccessible()) {
            results = verify.verify(this.file.getLocation().toString(), this.signatureId);
        } else {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickVerificationCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.QuickVerificationCommand_5));
        }
        if (results.size() == 1) {
            VerificationResult result = (VerificationResult)results.get(0);
            if (result.getSignature() != null) {
                Verification.showVerificationResult(result);
            } else {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickVerificationCommand_0, (String)NLS.bind((String)Messages.QuickVerificationCommand_4, (Object)this.signatureId));
            }
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickVerificationCommand_0, (String)NLS.bind((String)Messages.QuickVerificationCommand_4, (Object)this.signatureId));
        }
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.signatureId = store.getString("signatureID");
    }

    private boolean checkPreferences() {
        int result = 2;
        if (this.signatureId == null || "".equals(this.signatureId)) {
            MissingPreferenceDialog dialog = new MissingPreferenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickVerificationCommand_0, NLS.bind((String)Messages.MissingParameter, (Object)Messages.MissingSignatureId), "org.eclipse.wst.xml.security.ui.preferences.Signatures");
            result = dialog.open();
        } else {
            this.preferencesComplete = true;
        }
        if (result == 0) {
            this.preferencesComplete = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.preferencesComplete;
    }
}

