/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.preferences.Messages;
import org.eclipse.wst.xml.security.ui.preferences.PreferenceValues;

public class PreferencePageEncryption
extends PreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor encryptionType = null;
    private FileFieldEditor keystore = null;
    private Button bDocument;
    private Button bSelection;
    private Button bXpath;
    private Label lXpath;
    private Text tXpath;
    private Text tKeyName;
    private Combo cEncryptionAlgorithm;
    private Combo cKeyWrapAlgorithm;
    private Text tId;
    private ArrayList<Button> checkBoxes = new ArrayList();
    private ArrayList<Button> radioButtons;
    private ArrayList<Text> textControls;
    private ArrayList<Combo> comboBoxes = new ArrayList();
    private SelectionListener selectionListener;
    private ModifyListener modifyListener;

    public PreferencePageEncryption() {
        this.radioButtons = new ArrayList();
        this.textControls = new ArrayList();
        this.addListener();
    }

    private void addListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageEncryption.this.controlChanged(e.widget);
            }
        };
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreferencePageEncryption.this.controlModified(e.widget);
            }
        };
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(XSTUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.encryptionPrefsDesc);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group gResource = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        gResource.setLayout((Layout)layout);
        gResource.setLayoutData((Object)gd);
        gResource.setText(Messages.resource);
        int indent = 0;
        this.bDocument = this.addRadioButton((Composite)gResource, Messages.document, "encryptionResource", "document", indent);
        this.bDocument.addSelectionListener(this.selectionListener);
        this.bSelection = this.addRadioButton((Composite)gResource, Messages.selection, "encryptionResource", "selection", indent);
        this.bSelection.addSelectionListener(this.selectionListener);
        this.bXpath = this.addRadioButton((Composite)gResource, Messages.xpath, "encryptionResource", "xpath", indent);
        this.bXpath.addSelectionListener(this.selectionListener);
        indent = this.convertWidthInCharsToPixels(4);
        this.lXpath = new Label((Composite)gResource, 0);
        this.lXpath.setText(Messages.xpathExpression);
        this.lXpath.setEnabled(this.bXpath.getSelection());
        this.tXpath = this.addTextControl((Composite)gResource, this.lXpath, "encryptionXPath", indent);
        this.tXpath.addModifyListener(this.modifyListener);
        this.tXpath.setEnabled(this.bXpath.getSelection());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.encryptionType = new RadioGroupFieldEditor("encryptionType", Messages.type, 2, PreferenceValues.ENCRYPTION_TYPES, top, true);
        this.encryptionType.setPage((DialogPage)this);
        this.encryptionType.setPreferenceStore(this.getPreferenceStore());
        this.encryptionType.load();
        this.encryptionType.fillIntoGrid(top, 2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group gAlgorithms = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        gAlgorithms.setLayout((Layout)layout);
        gAlgorithms.setLayoutData((Object)gd);
        gAlgorithms.setText(Messages.algorithms);
        indent = 0;
        Label lEncryptionAlgorithm = new Label((Composite)gAlgorithms, 0);
        lEncryptionAlgorithm.setText(Messages.encryptionPrefsEncryptionAlgorithm);
        this.cEncryptionAlgorithm = this.addComboControl((Composite)gAlgorithms, lEncryptionAlgorithm, "encryptionEncryption", indent, Algorithms.ENCRYPTION_ALGORITHMS);
        this.cEncryptionAlgorithm.addModifyListener(this.modifyListener);
        Label lKeyWrapAlgorithm = new Label((Composite)gAlgorithms, 0);
        lKeyWrapAlgorithm.setText(Messages.encryptionPrefsAlgoKeyWrap);
        this.cKeyWrapAlgorithm = this.addComboControl((Composite)gAlgorithms, lKeyWrapAlgorithm, "encryptionKeyWrap", indent, Algorithms.KEY_WRAP_ALGORITHMS);
        this.cKeyWrapAlgorithm.addModifyListener(this.modifyListener);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group gKeystore = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        gKeystore.setLayout((Layout)layout);
        gKeystore.setLayoutData((Object)gd);
        gKeystore.setText(Messages.keystoreAndKey);
        indent = 0;
        this.keystore = new FileFieldEditor("encryptionKeyStore", Messages.keystore, (Composite)gKeystore);
        this.keystore.setFileExtensions(Globals.KEY_STORE_EXTENSION);
        this.keystore.setChangeButtonText(Messages.open);
        this.keystore.setPage((DialogPage)this);
        this.keystore.setPreferenceStore(this.getPreferenceStore());
        this.keystore.load();
        this.keystore.fillIntoGrid((Composite)gKeystore, 3);
        Label lKeyName = new Label((Composite)gKeystore, 0);
        lKeyName.setText(Messages.key);
        this.tKeyName = this.addTextControl((Composite)gKeystore, lKeyName, "encryptionKeyName", indent);
        this.tKeyName.addModifyListener(this.modifyListener);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group gId = new Group(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        gId.setLayout((Layout)layout);
        gId.setLayoutData((Object)gd);
        gId.setText(Messages.id);
        indent = 0;
        Label lId = new Label((Composite)gId, 0);
        lId.setText(Messages.id);
        this.tId = this.addTextControl((Composite)gId, lId, "encryptionID", indent);
        this.tId.addModifyListener(this.modifyListener);
        return top;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.preferences_encryption");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        IPreferenceStore store = this.getPreferenceStore();
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(store.getString(key)));
        this.radioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        IPreferenceStore store = this.getPreferenceStore();
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        text.setText(store.getString(key));
        this.textControls.add(text);
        return text;
    }

    private Combo addComboControl(Composite parent, Label labelControl, String key, int indent, String[] items) {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Combo combo = new Combo(parent, 2060);
        combo.setItems(items);
        combo.setData((Object)key);
        combo.setLayoutData((Object)gd);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItem(i).equals(store.getString(key))) {
                combo.select(i);
            }
            ++i;
        }
        this.comboBoxes.add(combo);
        return combo;
    }

    protected void performDefaults() {
        String key;
        IPreferenceStore store = this.getPreferenceStore();
        for (Button b : this.checkBoxes) {
            key = (String)b.getData();
            b.setSelection(store.getDefaultBoolean(key));
        }
        for (Button b : this.radioButtons) {
            String[] info = (String[])b.getData();
            b.setSelection(info[1].equals(store.getDefaultString(info[0])));
        }
        for (Text t : this.textControls) {
            key = (String)t.getData();
            t.setText(store.getDefaultString(key));
        }
        for (Combo c : this.comboBoxes) {
            key = (String)c.getData();
            int i = 0;
            while (i < c.getItemCount()) {
                if (c.getItem(i).equals(store.getDefaultString(key))) {
                    c.select(i);
                }
                ++i;
            }
        }
        this.encryptionType.loadDefault();
        this.keystore.loadDefault();
        super.performDefaults();
        this.validateXPath();
    }

    private void validateXPath() {
        boolean useXPathExpression = this.bXpath.getSelection();
        this.tXpath.setEnabled(useXPathExpression);
        this.lXpath.setEnabled(useXPathExpression);
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        String key;
        IPreferenceStore store = this.getPreferenceStore();
        for (Button b : this.checkBoxes) {
            key = (String)b.getData();
            store.setValue(key, b.getSelection());
        }
        for (Button b : this.radioButtons) {
            if (!b.getSelection()) continue;
            String[] info = (String[])b.getData();
            store.setValue(info[0], info[1]);
        }
        for (Text t : this.textControls) {
            key = (String)t.getData();
            store.setValue(key, t.getText());
        }
        for (Combo c : this.comboBoxes) {
            key = (String)c.getData();
            store.setValue(key, c.getItem(c.getSelectionIndex()));
        }
        this.encryptionType.store();
        this.keystore.store();
        return super.performOk();
    }

    private void controlChanged(Widget widget) {
        if (widget == this.bDocument || widget == this.bSelection) {
            this.lXpath.setEnabled(false);
            this.tXpath.setEnabled(false);
        } else if (widget == this.bXpath) {
            this.lXpath.setEnabled(true);
            this.tXpath.setEnabled(true);
        }
    }

    private void controlModified(Widget widget) {
    }
}

