/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.encrypt.CreateEncryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.commands.NewSignatureCommand;
import org.eclipse.wst.xml.security.ui.encrypt.NewEncryptionWizard;
import org.w3c.dom.Document;

public class NewEncryptionCommand
extends AbstractHandler {
    private ITextSelection textSelection = null;
    private ExecutionEvent event;
    private IFile file = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.createEncryption();
        return null;
    }

    private void createEncryption() {
        try {
            NewEncryptionWizard wizard = new NewEncryptionWizard();
            IDocument document = null;
            if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
                final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
                if (editorPart.isDirty()) {
                    if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                        IRunnableWithProgress op = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                editorPart.doSave(monitor);
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        }
                        catch (InvocationTargetException ite) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                        }
                        catch (InterruptedException ie) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                        }
                    } else {
                        editorPart.doSaveAs();
                    }
                }
                this.textSelection = (ITextSelection)((ITextEditor)editorPart.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
                this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                document = (IDocument)editorPart.getAdapter(IDocument.class);
            } else {
                this.textSelection = null;
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                if (selection instanceof IStructuredSelection) {
                    this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
                }
            }
            if (this.file != null && this.file.isAccessible()) {
                if (this.textSelection != null && Utils.parseSelection((String)this.textSelection.getText())) {
                    wizard.init(this.file, this.textSelection);
                } else {
                    wizard.init(this.file);
                }
                CreateEncryption encryption = new CreateEncryption();
                String fileLocation = "";
                if (document == null) {
                    fileLocation = this.file.getLocation().toString();
                }
                this.encryptData(encryption, wizard, document, fileLocation);
                if (wizard.getModel().getLaunchSignatureWizard()) {
                    this.launchXMLSignatureWizard();
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewEncryptionCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.NewEncryptionCommand_3));
            }
        }
        catch (Exception ex) {
            org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewEncryptionCommand_0, Messages.NewEncryptionCommand_1, ex);
            org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during encrypting", ex);
        }
    }

    private void encryptData(final CreateEncryption data, final NewEncryptionWizard wizard, final IDocument document, final String filename) throws Exception {
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job(Messages.NewEncryptionCommand_0){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.NewEncryptionCommand_2, 3);
                            Document doc = null;
                            doc = NewEncryptionCommand.this.textSelection != null ? data.encrypt(wizard.getModel(), NewEncryptionCommand.this.textSelection.getText(), monitor) : data.encrypt(wizard.getModel(), null, monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)true));
                                    break block8;
                                }
                                FileWriter fw = new FileWriter(filename);
                                fw.write(Utils.docToString((Document)doc, (boolean)true));
                                fw.flush();
                                fw.close();
                            }
                            catch (Exception ex) {
                                HandlerUtil.getActiveShell((ExecutionEvent)NewEncryptionCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)NewEncryptionCommand.this.event), Messages.NewEncryptionCommand_0, Messages.NewEncryptionCommand_1, ex);
                                        org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during encrypting", ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }

    private void launchXMLSignatureWizard() throws ExecutionException {
        NewSignatureCommand sign = new NewSignatureCommand();
        sign.signAfterEncryption(this.file);
        sign.execute(this.event);
    }

    public void encryptAfterSignature(IFile signedFile) {
        this.file = signedFile;
        this.createEncryption();
    }
}

