/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.dialogs.Messages;
import org.w3c.dom.Document;

public class XpathDialog
extends ElementListSelectionDialog {
    private IFile xmlDocument;

    public XpathDialog(Shell shell, ILabelProvider labelProvider) {
        super(shell, labelProvider);
    }

    public XpathDialog(Shell shell, ILabelProvider labelProvider, IFile file, String message) {
        super(shell, labelProvider);
        this.setTitle(Messages.xpathSelectionTitle);
        this.setMessage(message);
        this.xmlDocument = file;
        this.setElements(this.createContent());
        this.open();
    }

    protected Control createDialogArea(Composite parent) {
        Control comp = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(comp, "org.eclipse.wst.xml.security.doc.xpath_dialog");
        return comp;
    }

    private Object[] createContent() {
        try {
            Document doc = Utils.parse((IFile)this.xmlDocument);
            return Utils.getCompleteXpath((Document)doc);
        }
        catch (Exception e) {
            Status status = new Status(4, XSTUIPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.xpathSelectionError, (Throwable)e);
            XSTUIPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

