/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.decrypt.CreateDecryption;
import org.eclipse.wst.xml.security.core.decrypt.Decryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.dialogs.MissingPreferenceDialog;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class QuickDecryptionCommand
extends AbstractHandler {
    private IFile file = null;
    private Keystore keystore;
    private char[] keystorePassword;
    private String keyName;
    private char[] keyPassword;
    private String encryptionId;
    private String keyFile;
    private boolean completePrefs = false;
    private ExecutionEvent event;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            this.createDecryption();
        }
        return null;
    }

    private void createDecryption() {
        IDocument document = null;
        if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            document = (IDocument)editorPart.getAdapter(IDocument.class);
        } else {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (selection instanceof IStructuredSelection) {
                this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
            }
        }
        PasswordDialog keystorePasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_1, "");
        if (keystorePasswordDialog.open() != 0) {
            return;
        }
        this.keystorePassword = keystorePasswordDialog.getValue().toCharArray();
        PasswordDialog privateKeyPasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_3, "");
        if (privateKeyPasswordDialog.open() != 0) {
            return;
        }
        this.keyPassword = privateKeyPasswordDialog.getValue().toCharArray();
        if (this.checkPasswords()) {
            try {
                if (this.loadKeystore()) {
                    if (this.file != null && this.file.isAccessible()) {
                        this.decryptData(document);
                    } else {
                        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickDecryptionCommand_4, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.QuickDecryptionCommand_5));
                    }
                } else {
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickDecryptionCommand_4, (String)Messages.QuickDecryptionCommand_6);
                }
            }
            catch (SAXParseException spe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_7, spe);
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickDecryptionCommand_4, (String)Messages.QuickDecryptionCommand_8);
            }
            catch (IOException ioe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_9, ioe);
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_10, ex);
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick decrypting", ex);
            }
        }
    }

    private void decryptData(final IDocument document) {
        final CreateDecryption decryption = new CreateDecryption();
        final Decryption data = new Decryption();
        data.setKeystore(this.keystore);
        data.setKeystorePassword(this.keystorePassword);
        data.setKeyName(this.keyName);
        data.setKeyPassword(this.keyPassword);
        data.setEncryptionId(this.encryptionId);
        data.setFile(this.file.getLocation().toString());
        Job job = new Job(Messages.QuickDecryptionCommand_4){

            public IStatus run(IProgressMonitor monitor) {
                block8: {
                    try {
                        monitor.beginTask(Messages.QuickDecryptionCommand_11, 5);
                        Document doc = null;
                        doc = decryption.decrypt(data, monitor);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            if (doc == null) break block8;
                            if (document != null) {
                                document.set(Utils.docToString((Document)doc, (boolean)false));
                                break block8;
                            }
                            FileOutputStream fos = new FileOutputStream(QuickDecryptionCommand.this.file.getLocation().toOSString());
                            XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception ex) {
                            HandlerUtil.getActiveShell((ExecutionEvent)QuickDecryptionCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)QuickDecryptionCommand.this.event), Messages.QuickDecryptionCommand_4, Messages.QuickDecryptionCommand_12, ex);
                                    org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during decrypting", ex);
                                }
                            });
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean loadKeystore() throws Exception {
        block3: {
            try {
                this.keystore = new Keystore(this.keyFile, this.keystorePassword.toString(), "JCEKS");
                this.keystore.load();
                if (this.keystore.containsKey(this.keyName)) break block3;
                return false;
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick encryption", ex);
                return false;
            }
        }
        return this.keystore.getSecretKey(this.keyName, this.keyPassword) != null;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.keyFile = store.getString("encryptionKeyStore");
        this.keyName = store.getString("encryptionKeyName");
        this.encryptionId = store.getString("encryptionID");
    }

    private boolean checkPreferences() {
        String title = Messages.QuickDecryptionCommand_4;
        int result = 2;
        if (this.keystore == null || this.keystore.equals("")) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickDecryptionCommand_15), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.keyName == null || this.keyName.equals("")) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickDecryptionCommand_16), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }

    private boolean checkPasswords() {
        if (this.keystorePassword == null || this.keystorePassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickDecryptionCommand_4, (String)Messages.QuickDecryptionCommand_1);
            return false;
        }
        if (this.keyPassword == null || this.keyPassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickDecryptionCommand_4, (String)Messages.QuickDecryptionCommand_3);
            return false;
        }
        return true;
    }

    private int showMissingParameterDialog(String title, String message, String prefId) {
        MissingPreferenceDialog dialog = new MissingPreferenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), title, message, prefId);
        return dialog.open();
    }
}

