/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.core.verify;

import org.apache.xml.security.signature.XMLSignature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.security.core.verify.Messages;

public class VerificationResult {
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    public static final String UNKNOWN = "unknown";
    private String signatureId;
    private String signatureStatus;
    private String certificateType;
    private String certificateAlgorithm;
    private XMLSignature signature;

    public VerificationResult(String status, String id, String type, String algorithm, XMLSignature xmlSignature) {
        this.signatureStatus = status;
        this.signatureId = id;
        this.certificateType = type;
        this.certificateAlgorithm = algorithm;
        this.signature = xmlSignature;
    }

    public String getId() {
        return this.signatureId;
    }

    public String getStatus() {
        return this.signatureStatus;
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public String getAlgorithm() {
        return this.certificateAlgorithm;
    }

    public String getType() {
        return this.certificateType;
    }

    public String resultToReadableString() {
        String resultString = NLS.bind((String)Messages.verificationResult, (Object[])new Object[]{this.getId(), this.getStatus(), this.getType(), this.getAlgorithm()});
        return resultString;
    }
}

