/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.encrypt;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.encrypt.Messages;
import org.eclipse.wst.xml.security.ui.encrypt.PageAlgorithms;
import org.eclipse.wst.xml.security.ui.encrypt.PageCreateKey;
import org.eclipse.wst.xml.security.ui.encrypt.PageCreateKeystore;
import org.eclipse.wst.xml.security.ui.encrypt.PageOpenKey;
import org.eclipse.wst.xml.security.ui.encrypt.PageResource;

public class NewEncryptionWizard
extends Wizard
implements INewWizard {
    private PageResource pageResource = null;
    private PageOpenKey pageOpenKey = null;
    private PageCreateKey pageCreateKey = null;
    private PageCreateKeystore pageCreateKeystore = null;
    private PageAlgorithms pageAlgorithms = null;
    private IFile file;
    private ITextSelection textSelection;
    private Encryption encryption = new Encryption();
    public static final String SETTING_KEYSTORE = "enc_keystore";
    public static final String SETTING_KEY_NAME = "enc_key_name";
    public static final String SETTING_BSP_COMPLIANT_ENCRYPTION = "enc_bsp_compliant";
    public static final String SETTING_SET_PLAIN_ROOT_ELEMENT = "enc_plain_root_element";
    public static final String SETTING_CALL_SIGNATURE_WIZARD = "enc_sign";

    public NewEncryptionWizard() {
        this.setWindowTitle(Messages.encryptionWizard);
        this.setDialogSettings(this.getEncryptionWizardSettings());
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)XSTUIPlugin.getId(), (String)"icons/wiz_enc.gif");
        this.setDefaultPageImageDescriptor(image);
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getEncryptionWizardSettings() {
        IDialogSettings workbenchSettings = XSTUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("EncryptionWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("EncryptionWizard");
        }
        return section;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void init(IFile file) {
        this.init(file, null);
    }

    public void init(IFile file, ITextSelection textSelection) {
        this.file = file;
        this.textSelection = textSelection;
    }

    public void addPages() {
        String path = this.file.getLocation().removeFileExtension().removeLastSegments(1).toString();
        String name = this.file.getLocation().removeFileExtension().removeLastSegments(1).lastSegment();
        this.pageResource = new PageResource(this.encryption, this.file, this.textSelection != null);
        this.addPage((IWizardPage)this.pageResource);
        this.pageOpenKey = new PageOpenKey(this.encryption, path);
        this.addPage((IWizardPage)this.pageOpenKey);
        this.pageCreateKey = new PageCreateKey(this.encryption, path, name);
        this.addPage((IWizardPage)this.pageCreateKey);
        this.pageCreateKeystore = new PageCreateKeystore(this.encryption, path, name);
        this.addPage((IWizardPage)this.pageCreateKeystore);
        this.pageAlgorithms = new PageAlgorithms(this.encryption, this.file);
        this.addPage((IWizardPage)this.pageAlgorithms);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.pageAlgorithms) {
            return false;
        }
        return this.pageAlgorithms.isPageComplete();
    }

    public boolean performFinish() {
        return this.pageAlgorithms.performFinish();
    }

    public Encryption getModel() {
        return this.encryption;
    }

    public PageResource getPageResource() {
        return this.pageResource;
    }

    public PageOpenKey getPageOpenKey() {
        return this.pageOpenKey;
    }

    public PageCreateKey getPageCreateKey() {
        return this.pageCreateKey;
    }

    public PageCreateKeystore getPageCreateKeystore() {
        return this.pageCreateKeystore;
    }

    public PageAlgorithms getPageAlgorithms() {
        return this.pageAlgorithms;
    }
}

