/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.security.core.verify.VerifyDocument;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.utils.Utils;
import org.eclipse.wst.xml.security.ui.verify.SignatureView;

public class RefreshSignaturesCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (HandlerUtil.getActiveEditor((ExecutionEvent)event) != null) {
            final IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            try {
                IViewPart vp;
                ArrayList results = new ArrayList();
                VerifyDocument verify = new VerifyDocument();
                IFile file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                if (file != null) {
                    results = verify.verify(file.getLocation().toString());
                } else {
                    MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RefreshSignaturesCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.RefreshSignaturesCommand_1));
                }
                if (results.size() == 0) {
                    MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RefreshSignaturesCommand_0, (String)Messages.RefreshSignaturesCommand_2);
                }
                if ((vp = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().showView("org.eclipse.wst.xml.security.ui.SignatureView")) instanceof SignatureView) {
                    ((SignatureView)vp).setInput(results);
                }
            }
            catch (XMLSignatureException xmlse) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RefreshSignaturesCommand_3, (String)xmlse.getLocalizedMessage());
            }
            catch (KeyResolverException kre) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RefreshSignaturesCommand_4, (String)kre.getLocalizedMessage());
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RefreshSignaturesCommand_5, (String)ex.getLocalizedMessage());
                Utils.log("Error during verification of XML signature", ex);
            }
        }
        return null;
    }
}

