/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.cheatsheets;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.cheatsheets.Messages;
import org.osgi.framework.Bundle;

public class CreateSampleProject
extends Action
implements ICheatSheetAction {
    private static final String EXAMPLE_PROJECT = "XML-Security";
    private static final String EXAMPLE_FILE = "FirstSteps.xml";
    private static final String SAMPLE_FILE = "resources/FirstSteps.xml";

    public void run(String[] params, ICheatSheetManager manager) {
        try {
            IFile sampleFile;
            IProject sampleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(EXAMPLE_PROJECT);
            if (!sampleProject.exists()) {
                sampleProject.create(null);
            }
            if (!sampleProject.isOpen()) {
                sampleProject.open(null);
            }
            if (!(sampleFile = sampleProject.getFile((IPath)new Path(EXAMPLE_FILE))).exists()) {
                InputStream sampleData = null;
                try {
                    sampleData = FileLocator.openStream((Bundle)XSTUIPlugin.getDefault().getBundle(), (IPath)new Path(SAMPLE_FILE), (boolean)false);
                    sampleFile.create(sampleData, true, null);
                }
                catch (Exception ex) {
                    String reason;
                    if (sampleData != null) {
                        sampleData.close();
                    }
                    if ((reason = ex.getMessage()) == null) {
                        reason = Messages.errorReasonUnavailable;
                    }
                    Status status = new Status(4, XSTUIPlugin.getDefault().getBundle().getSymbolicName(), 0, reason, (Throwable)ex);
                    XSTUIPlugin.getDefault().getLog().log((IStatus)status);
                    this.showErrorDialog(Messages.error, Messages.createProjectFileXMLError, reason, (IStatus)status);
                }
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(sampleFile), PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(sampleFile.getName()).getId(), true);
        }
        catch (Exception ex) {
            String reason = ex.getMessage();
            if (reason == null) {
                reason = Messages.errorReasonUnavailable;
            }
            Status status = new Status(4, XSTUIPlugin.getDefault().getBundle().getSymbolicName(), 0, reason, (Throwable)ex);
            XSTUIPlugin.getDefault().getLog().log((IStatus)status);
            this.showErrorDialog(Messages.error, Messages.createProjectFileXMLError, reason, (IStatus)status);
        }
    }

    private void showErrorDialog(String title, String message, String reason, IStatus status) {
        ErrorDialog errorDialog = new ErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, status, 4);
        errorDialog.open();
    }
}

