/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.sign;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.sign.DigitalSignatureProperty;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.sign.EditableTableItem;
import org.eclipse.wst.xml.security.ui.sign.Messages;

public class PageAlgorithms
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "SignPageAlgorithms";
    private Combo cMDA = null;
    private Combo cSign = null;
    private Combo cCanon = null;
    private Combo cTransform = null;
    private Text tId = null;
    private Button bEncWiz = null;
    private IFile file;
    private String[] ids;
    private Table properties = null;
    private TableViewer tableViewer = null;
    private static final String ID_PROPERTY = "id";
    private static final String TARGET_PROPERTY = "target";
    private static final String CONTENT_PROPERTY = "content";
    private Button bAddProperty = null;
    private Button bRemoveProperty = null;
    private static final String SETTING_CALL_ENCRYPTION_WIZARD = "sign_enc";
    private Signature signature = null;

    public PageAlgorithms(Signature signature, IFile file) {
        super(PAGE_NAME);
        this.setTitle(Messages.signatureTitle);
        this.setDescription(Messages.algorithmsDescription);
        this.signature = signature;
        this.file = file;
        this.determineIds();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_signature_algorithms");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gTransform = new Group(parent, 16);
        gTransform.setLayout((Layout)layout);
        gTransform.setText(Messages.canonicalizationTransformation);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gTransform.setLayoutData((Object)data);
        Group gSign = new Group(parent, 16);
        gSign.setLayout((Layout)layout);
        gSign.setText(Messages.messageDigestSignature);
        data = new FormData();
        data.top = new FormAttachment((Control)gTransform, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gSign.setLayoutData((Object)data);
        Group gProperties = new Group(parent, 16);
        gProperties.setLayout((Layout)layout);
        gProperties.setText(Messages.properties);
        data = new FormData();
        data.top = new FormAttachment((Control)gSign, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gProperties.setLayoutData((Object)data);
        Group gID = new Group(parent, 16);
        gID.setLayout((Layout)layout);
        gID.setText(Messages.signatureId);
        data = new FormData();
        data.top = new FormAttachment((Control)gProperties, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gID.setLayoutData((Object)data);
        Group gEncWiz = new Group(parent, 16);
        gEncWiz.setLayout((Layout)layout);
        gEncWiz.setText(Messages.encryptionWizard);
        data = new FormData();
        data.top = new FormAttachment((Control)gID, 20, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gEncWiz.setLayoutData((Object)data);
        this.cCanon = new Combo((Composite)gTransform, 8);
        data = new FormData();
        data.left = new FormAttachment((Control)gTransform);
        data.top = new FormAttachment((Control)gTransform);
        data.width = 200;
        this.cCanon.setLayoutData((Object)data);
        this.cTransform = new Combo((Composite)gTransform, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)gTransform);
        data.left = new FormAttachment((Control)this.cCanon, 20);
        data.width = 200;
        this.cTransform.setLayoutData((Object)data);
        this.cMDA = new Combo((Composite)gSign, 8);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)gSign);
        data.left = new FormAttachment((Control)gSign);
        this.cMDA.setLayoutData((Object)data);
        this.cSign = new Combo((Composite)gSign, 8);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)gSign);
        data.left = new FormAttachment((Control)this.cMDA, 20);
        this.cSign.setLayoutData((Object)data);
        this.properties = new Table((Composite)gProperties, 65536);
        this.properties.setHeaderVisible(true);
        this.properties.setLinesVisible(true);
        this.addProperties();
        data = new FormData();
        data.top = new FormAttachment((Control)gProperties);
        data.left = new FormAttachment((Control)gProperties);
        data.width = 350;
        data.height = 50;
        this.properties.setLayoutData((Object)data);
        this.bAddProperty = new Button((Composite)gProperties, 8);
        this.bAddProperty.setText("+");
        data = new FormData();
        data.top = new FormAttachment((Control)gProperties, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.properties, 10);
        data.width = 50;
        this.bAddProperty.setLayoutData((Object)data);
        this.bRemoveProperty = new Button((Composite)gProperties, 8);
        this.bRemoveProperty.setText("-");
        data = new FormData();
        data.top = new FormAttachment((Control)gProperties, 25, 0x1000000);
        data.left = new FormAttachment((Control)this.properties, 10);
        data.width = 50;
        this.bRemoveProperty.setLayoutData((Object)data);
        Label lID = new Label((Composite)gID, 4);
        lID.setText(Messages.signatureId);
        data = new FormData();
        data.top = new FormAttachment((Control)gID);
        data.left = new FormAttachment((Control)gID);
        data.width = 80;
        lID.setLayoutData((Object)data);
        this.tId = new Text((Composite)gID, 4);
        this.tId.setTextLimit(20);
        data = new FormData();
        data.top = new FormAttachment((Control)gID);
        data.left = new FormAttachment((Control)lID);
        data.width = 225;
        this.tId.setLayoutData((Object)data);
        this.bEncWiz = new Button((Composite)gEncWiz, 32);
        this.bEncWiz.setText(Messages.startEncryptionWizard);
        data = new FormData();
        data.top = new FormAttachment((Control)gEncWiz);
        data.left = new FormAttachment((Control)gEncWiz);
        this.bEncWiz.setLayoutData((Object)data);
    }

    private void addProperties() {
        this.tableViewer = new TableViewer(this.properties);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(125, 100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(175, 150, true));
        this.properties.setLayout((Layout)layout);
        TableColumn colId = new TableColumn(this.properties, 16384);
        colId.setText(Messages.signaturePropertyId);
        colId.setToolTipText(Messages.signaturePropertyIdToolTip);
        TableColumn colTarget = new TableColumn(this.properties, 16384);
        colTarget.setText(Messages.signaturePropertyTarget);
        colTarget.setToolTipText(Messages.signaturePropertyTargetToolTip);
        TableColumn colContent = new TableColumn(this.properties, 16384);
        colContent.setText(Messages.signaturePropertyContent);
        colContent.setToolTipText(Messages.signaturePropertyContentToolTip);
        this.attachLabelProvider(this.tableViewer);
        this.attachCellEditors(this.tableViewer, (Composite)this.properties);
        MenuManager popupMenu = new MenuManager();
        NewRowAction newRowAction = new NewRowAction();
        RemoveRowAction removeRowAction = new RemoveRowAction();
        popupMenu.add((IAction)newRowAction);
        popupMenu.add((IAction)removeRowAction);
        Menu menu = popupMenu.createContextMenu((Control)this.properties);
        this.properties.setMenu(menu);
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof String) {
                    return (String)element;
                }
                switch (columnIndex) {
                    case 0: {
                        return ((EditableTableItem)element).getId();
                    }
                    case 1: {
                        return ((EditableTableItem)element).getTarget();
                    }
                    case 2: {
                        return ((EditableTableItem)element).getContent();
                    }
                }
                return "Invalid column: " + columnIndex;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (PageAlgorithms.ID_PROPERTY.equals(property)) {
                    return ((EditableTableItem)element).getId();
                }
                if (PageAlgorithms.TARGET_PROPERTY.equals(property)) {
                    return ((EditableTableItem)element).getTarget();
                }
                if (PageAlgorithms.CONTENT_PROPERTY.equals(property)) {
                    return ((EditableTableItem)element).getContent();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                EditableTableItem data = (EditableTableItem)tableItem.getData();
                if (PageAlgorithms.ID_PROPERTY.equals(property)) {
                    data.setId(value.toString());
                } else if (PageAlgorithms.TARGET_PROPERTY.equals(property)) {
                    data.setTarget(value.toString());
                } else if (PageAlgorithms.CONTENT_PROPERTY.equals(property)) {
                    data.setContent(value.toString());
                }
                viewer.refresh((Object)data);
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new TextCellEditor(parent), new TextCellEditor(parent)});
        viewer.setColumnProperties(new String[]{ID_PROPERTY, TARGET_PROPERTY, CONTENT_PROPERTY});
    }

    private void addListeners() {
        this.cMDA.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.cSign.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.cCanon.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.cTransform.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.tId.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127) {
                    e.doit = true;
                } else if (!Utils.validateId((String)e.text)) {
                    e.doit = false;
                }
            }
        });
        this.tId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageAlgorithms.this.dialogChanged();
            }
        });
        this.bAddProperty.addListener(13, (Listener)this);
        this.bRemoveProperty.addListener(13, (Listener)this);
    }

    private void determineIds() {
        try {
            this.ids = Utils.getAllIds((InputStream)this.file.getContents());
        }
        catch (Exception exception) {
            this.ids = new String[0];
        }
    }

    private void dialogChanged() {
        boolean uniqueId;
        if (this.cCanon.getText().equals("")) {
            this.updateStatus(Messages.selectCanonicalization, 1);
            return;
        }
        if (this.cTransform.getText().equals("")) {
            this.updateStatus(Messages.selectTransformation, 1);
            return;
        }
        if (this.cMDA.getText().equals("")) {
            this.updateStatus(Messages.selectMessageDigest, 1);
            return;
        }
        if (this.cSign.getText().equals("")) {
            this.updateStatus(Messages.selectSignature, 1);
            return;
        }
        if (!this.tId.getText().equals("") && this.ids.length > 0 && !(uniqueId = Utils.ensureIdIsUnique((String)this.tId.getText(), (String[])this.ids))) {
            this.updateStatus(Messages.ambiguousSignatureId, 3);
            return;
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (message == null && this.getErrorMessage() == null) {
            this.setPageComplete(true);
            this.saveDataToModel();
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean performFinish() {
        return this.saveDataToModel();
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bAddProperty) {
            new NewRowAction().run();
        } else if (e.widget == this.bRemoveProperty) {
            new RemoveRowAction().run();
        }
    }

    public boolean isPageComplete() {
        this.saveDataToModel();
        return this.getMessage() == null && this.getErrorMessage() == null;
    }

    private boolean saveDataToModel() {
        this.signature.setMessageDigestAlgorithm(this.cMDA.getText());
        this.signature.setSignatureAlgorithm(this.cSign.getText());
        this.signature.setCanonicalizationAlgorithm(this.cCanon.getText());
        this.signature.setTransformationAlgorithm(this.cTransform.getText());
        if (this.properties.getItemCount() > 0) {
            ArrayList<DigitalSignatureProperty> signatureProperties = new ArrayList<DigitalSignatureProperty>();
            int i = 0;
            while (i < this.properties.getItemCount()) {
                TableItem tableItem = this.properties.getItem(i);
                EditableTableItem data = (EditableTableItem)tableItem.getData();
                if (!"".equals(data.getId()) && !"".equals(data.getTarget())) {
                    signatureProperties.add(new DigitalSignatureProperty(data.getId(), data.getTarget(), data.getContent()));
                }
                ++i;
            }
            this.signature.setSignatureProperties(signatureProperties);
        }
        this.signature.setSignatureId(this.tId.getText());
        this.signature.setLaunchEncryptionWizard(this.bEncWiz.getSelection());
        return true;
    }

    public void onEnterPage() {
        File detachedFile = this.signature.getDetachedFile();
        String type = this.signature.getSignatureType();
        String certificateType = this.signature.getKeyAlgorithm();
        String fileType = null;
        if (detachedFile != null) {
            String fileName = detachedFile.getName();
            fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        if (this.signature.getBsp()) {
            this.cCanon.setItems(Algorithms.CANONICALIZATION_ALOGRITHMS_BSP);
            this.cCanon.setText(Algorithms.CANONICALIZATION_ALOGRITHMS_BSP[0]);
            if (fileType == null || fileType.equalsIgnoreCase("xml")) {
                this.cTransform.setItems(Algorithms.TRANSFORMATION_ALOGRITHMS_BSP);
                this.cTransform.select(0);
            } else {
                this.cTransform.setItems(Algorithms.NONE_ALGORITHM);
                this.cTransform.select(0);
            }
            this.cMDA.setItems(Algorithms.MD_ALOGRITHMS_BSP);
            this.cMDA.select(0);
            this.cSign.setItems(Algorithms.SIGNATURE_ALOGRITHMS_BSP);
            this.cSign.select(0);
        } else {
            this.cCanon.setItems(Algorithms.CANONICALIZATION_ALOGRITHMS);
            this.cCanon.select(0);
            if (type.equalsIgnoreCase("detached") && !fileType.equalsIgnoreCase("xml")) {
                this.cTransform.setItems(Algorithms.NONE_ALGORITHM);
                this.cTransform.select(0);
            } else {
                this.cTransform.setItems(Algorithms.TRANSFORMATION_ALOGRITHMS);
                this.cTransform.select(4);
            }
            this.cMDA.setItems(Algorithms.MD_ALOGRITHMS);
            this.cMDA.setText(Algorithms.MD_ALOGRITHMS[2]);
            if (certificateType.equals("SHA1withDSA")) {
                this.cSign.setItems(Algorithms.SIGNATURE_ALOGRITHMS_DSA);
                this.cSign.select(0);
            } else if (certificateType.equals("SHA1withECDSA")) {
                this.cSign.setItems(Algorithms.SIGNATURE_ALOGRITHMS_EC);
                this.cSign.select(0);
            } else if (certificateType.equals("SHA1withRSA")) {
                this.cSign.setItems(Algorithms.SIGNATURE_ALOGRITHMS_RSA);
                this.cSign.select(3);
            } else {
                this.cSign.setItems(Algorithms.SIGNATURE_ALOGRITHMS);
                this.cSign.select(0);
            }
        }
        this.setMessage(null);
    }

    private void loadSettings() {
        this.bEncWiz.setSelection(this.getDialogSettings().get(SETTING_CALL_ENCRYPTION_WIZARD) != null ? this.getDialogSettings().getBoolean(SETTING_CALL_ENCRYPTION_WIZARD) : false);
    }

    protected void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTING_CALL_ENCRYPTION_WIZARD, this.bEncWiz.getSelection());
    }

    private class NewRowAction
    extends Action {
        public NewRowAction() {
            super(Messages.buttonAddProperty);
        }

        public void run() {
            PageAlgorithms.this.tableViewer.add((Object)new EditableTableItem("", "", ""));
        }
    }

    private class RemoveRowAction
    extends Action {
        public RemoveRowAction() {
            super(Messages.buttonRemoveProperty);
        }

        public void run() {
            if (PageAlgorithms.this.properties.getSelectionIndex() > -1) {
                PageAlgorithms.this.properties.remove(PageAlgorithms.this.properties.getSelectionIndex());
            }
        }
    }
}

