/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.sign;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.sign.Messages;
import org.eclipse.wst.xml.security.ui.sign.PageAlgorithms;
import org.eclipse.wst.xml.security.ui.sign.PageCreateKey;
import org.eclipse.wst.xml.security.ui.sign.PageCreateKeystore;
import org.eclipse.wst.xml.security.ui.sign.PageOpenKey;
import org.eclipse.wst.xml.security.ui.sign.PageResource;

public class NewSignatureWizard
extends Wizard
implements INewWizard {
    private PageResource pageResource = null;
    private PageOpenKey pageOpenKey = null;
    private PageCreateKey pageCreateKey = null;
    private PageCreateKeystore pageCreateKeystore = null;
    private PageAlgorithms pageAlgorithms = null;
    private IFile file;
    private ITextSelection textSelection;
    private Signature signature = new Signature();

    public NewSignatureWizard() {
        this.setWindowTitle(Messages.signatureWizard);
        this.setDialogSettings(this.getSignatureWizardSettings());
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)XSTUIPlugin.getId(), (String)"icons/wiz_sig.gif");
        this.setDefaultPageImageDescriptor(image);
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getSignatureWizardSettings() {
        IDialogSettings workbenchSettings = XSTUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("SignatureWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("SignatureWizard");
        }
        return section;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void init(IFile file) {
        this.init(file, null);
    }

    public void init(IFile file, ITextSelection textSelection) {
        this.file = file;
        this.textSelection = textSelection;
    }

    public void addPages() {
        String path = this.file.getLocation().removeFileExtension().removeLastSegments(1).toString();
        String name = this.file.getLocation().removeFileExtension().removeLastSegments(1).lastSegment();
        this.pageResource = new PageResource(this.signature, this.file, this.textSelection != null);
        this.addPage((IWizardPage)this.pageResource);
        this.pageOpenKey = new PageOpenKey(this.signature, path);
        this.addPage((IWizardPage)this.pageOpenKey);
        this.pageCreateKey = new PageCreateKey(this.signature, path);
        this.addPage((IWizardPage)this.pageCreateKey);
        this.pageCreateKeystore = new PageCreateKeystore(this.signature, path, name);
        this.addPage((IWizardPage)this.pageCreateKeystore);
        this.pageAlgorithms = new PageAlgorithms(this.signature, this.file);
        this.addPage((IWizardPage)this.pageAlgorithms);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.pageAlgorithms) {
            return false;
        }
        return this.pageAlgorithms.isPageComplete();
    }

    public boolean performFinish() {
        this.pageResource.storeSettings();
        this.pageOpenKey.storeSettings();
        this.pageAlgorithms.storeSettings();
        return this.pageAlgorithms.performFinish();
    }

    public Signature getModel() {
        return this.signature;
    }

    public PageResource getPageResource() {
        return this.pageResource;
    }

    public PageOpenKey getPageOpenKey() {
        return this.pageOpenKey;
    }

    public PageCreateKey getPageCreateKey() {
        return this.pageCreateKey;
    }

    public PageCreateKeystore getPageCreateKeystore() {
        return this.pageCreateKeystore;
    }

    public PageAlgorithms getPageAlgorithms() {
        return this.pageAlgorithms;
    }
}

