/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.sign;

import java.io.File;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.sign.Messages;
import org.eclipse.wst.xml.security.ui.sign.NewSignatureWizard;
import org.eclipse.wst.xml.security.ui.sign.PageAlgorithms;

public class PageCreateKeystore
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "SignPageCreateKeystore";
    private String keystorePath;
    private String keystoreName;
    private String path;
    private String name;
    private boolean generated = false;
    private Button bGenerate = null;
    private Button bEchoKeystorePassword = null;
    private Button bEchoKeyPassword = null;
    private Combo cKeyAlgorithm = null;
    private Label lPreview = null;
    private Label lResult = null;
    private Text tCommonName = null;
    private Text tOrganizationalUnit = null;
    private Text tOrganization = null;
    private Text tLocation = null;
    private Text tState = null;
    private Text tCountry = null;
    private Text tKeystoreName = null;
    private Text tKeystorePassword = null;
    private Text tKeyName = null;
    private Text tKeyPassword = null;
    private static final int LABELWIDTH = 160;
    private static final int TEXTHEIGHT = 40;
    private Signature signature = null;
    private Keystore keystore = null;

    public PageCreateKeystore(Signature signature, String path, String name) {
        super(PAGE_NAME);
        this.setTitle(Messages.signatureTitle);
        this.setDescription(Messages.createKeystoreDescription);
        this.signature = signature;
        this.path = path;
        this.name = name;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_signature_create_keystore");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gCertificate = new Group(parent, 16);
        gCertificate.setLayout((Layout)layout);
        gCertificate.setText(Messages.certificate);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gCertificate.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.key);
        data = new FormData();
        data.top = new FormAttachment((Control)gCertificate, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Group gKeystore = new Group(parent, 16);
        gKeystore.setLayout((Layout)layout);
        gKeystore.setText(Messages.keystore);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKeystore.setLayoutData((Object)data);
        Label lCommonName = new Label((Composite)gCertificate, 4);
        lCommonName.setText(Messages.commonName);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gCertificate);
        data.left = new FormAttachment((Control)gCertificate);
        lCommonName.setLayoutData((Object)data);
        this.tCommonName = new Text((Composite)gCertificate, 4);
        this.tCommonName.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lCommonName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lCommonName);
        this.tCommonName.setLayoutData((Object)data);
        Label lOrganizationalUnit = new Label((Composite)gCertificate, 4);
        lOrganizationalUnit.setText(Messages.organizationalUnit);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lCommonName, 10);
        data.left = new FormAttachment((Control)gCertificate);
        lOrganizationalUnit.setLayoutData((Object)data);
        this.tOrganizationalUnit = new Text((Composite)gCertificate, 4);
        this.tOrganizationalUnit.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lOrganizationalUnit, 0, 0x1000000);
        data.left = new FormAttachment((Control)lOrganizationalUnit);
        this.tOrganizationalUnit.setLayoutData((Object)data);
        Label lOrganization = new Label((Composite)gCertificate, 4);
        lOrganization.setText(Messages.organization);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lOrganizationalUnit, 10);
        data.left = new FormAttachment((Control)gCertificate);
        lOrganization.setLayoutData((Object)data);
        this.tOrganization = new Text((Composite)gCertificate, 4);
        this.tOrganization.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lOrganization, 0, 0x1000000);
        data.left = new FormAttachment((Control)lOrganization);
        this.tOrganization.setLayoutData((Object)data);
        Label lLocation = new Label((Composite)gCertificate, 4);
        lLocation.setText(Messages.location);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lOrganization, 10);
        data.left = new FormAttachment((Control)gCertificate);
        lLocation.setLayoutData((Object)data);
        this.tLocation = new Text((Composite)gCertificate, 4);
        this.tLocation.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lLocation, 0, 0x1000000);
        data.left = new FormAttachment((Control)lLocation);
        this.tLocation.setLayoutData((Object)data);
        Label lState = new Label((Composite)gCertificate, 4);
        lState.setText(Messages.state);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lLocation, 10);
        data.left = new FormAttachment((Control)gCertificate);
        lState.setLayoutData((Object)data);
        this.tState = new Text((Composite)gCertificate, 4);
        this.tState.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lState, 0, 0x1000000);
        data.left = new FormAttachment((Control)lState);
        this.tState.setLayoutData((Object)data);
        Label lCountry = new Label((Composite)gCertificate, 4);
        lCountry.setText(Messages.country);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lState, 10);
        data.left = new FormAttachment((Control)gCertificate);
        lCountry.setLayoutData((Object)data);
        this.tCountry = new Text((Composite)gCertificate, 4);
        this.tCountry.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lCountry, 0, 0x1000000);
        data.left = new FormAttachment((Control)lCountry);
        this.tCountry.setLayoutData((Object)data);
        this.lPreview = new Label((Composite)gCertificate, 64);
        data = new FormData();
        data.height = 40;
        data.top = new FormAttachment((Control)lCountry, 10);
        data.left = new FormAttachment((Control)gCertificate);
        data.right = new FormAttachment(100);
        this.lPreview.setLayoutData((Object)data);
        Label lKeyName = new Label((Composite)gKey, 4);
        lKeyName.setText(Messages.name);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        lKeyName.setLayoutData((Object)data);
        this.tKeyName = new Text((Composite)gKey, 4);
        this.tKeyName.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyName);
        this.tKeyName.setLayoutData((Object)data);
        Label lKeyPassword = new Label((Composite)gKey, 4);
        lKeyPassword.setText(Messages.password);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeyName, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyPassword.setLayoutData((Object)data);
        this.tKeyPassword = new Text((Composite)gKey, 4);
        this.tKeyPassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyPassword);
        this.tKeyPassword.setEchoChar('*');
        this.tKeyPassword.setLayoutData((Object)data);
        Label lKeyAlgorithm = new Label((Composite)gKey, 4);
        lKeyAlgorithm.setText(Messages.keyAlgorithm);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeyPassword, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyAlgorithm.setLayoutData((Object)data);
        this.cKeyAlgorithm = new Combo((Composite)gKey, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyAlgorithm, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyAlgorithm);
        data.width = 150;
        this.cKeyAlgorithm.setLayoutData((Object)data);
        this.bEchoKeyPassword = new Button((Composite)gKey, 8);
        this.bEchoKeyPassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeyPassword, 10);
        this.bEchoKeyPassword.setLayoutData((Object)data);
        Label lKeystoreName = new Label((Composite)gKeystore, 4);
        lKeystoreName.setText(Messages.name);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gKeystore);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystoreName.setLayoutData((Object)data);
        this.tKeystoreName = new Text((Composite)gKeystore, 4);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystoreName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystoreName);
        this.tKeystoreName.setLayoutData((Object)data);
        Label lKeystorePassword = new Label((Composite)gKeystore, 4);
        lKeystorePassword.setText(Messages.password);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeystoreName, 10);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystorePassword.setLayoutData((Object)data);
        this.tKeystorePassword = new Text((Composite)gKeystore, 4);
        this.tKeystorePassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystorePassword);
        this.tKeystorePassword.setEchoChar('*');
        this.tKeystorePassword.setLayoutData((Object)data);
        this.bEchoKeystorePassword = new Button((Composite)gKeystore, 8);
        this.bEchoKeystorePassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystorePassword, 10);
        this.bEchoKeystorePassword.setLayoutData((Object)data);
        this.bGenerate = new Button((Composite)gKeystore, 8);
        this.bGenerate.setText(Messages.generate);
        this.bGenerate.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystorePassword, 20);
        data.left = new FormAttachment((Control)gKeystore);
        this.bGenerate.setLayoutData((Object)data);
        this.lResult = new Label((Composite)gKeystore, 64);
        data = new FormData();
        data.height = 40;
        data.top = new FormAttachment((Control)this.bGenerate, 20);
        data.left = new FormAttachment((Control)gKeystore);
        data.right = new FormAttachment(100);
        this.lResult.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.bGenerate.addListener(3, (Listener)this);
        this.bEchoKeystorePassword.addListener(13, (Listener)this);
        this.bEchoKeyPassword.addListener(13, (Listener)this);
        this.tCommonName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tOrganizationalUnit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tOrganization.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tState.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tCountry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tKeyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.cKeyAlgorithm.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tKeystoreName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
        this.tKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKeystore.this.dialogChanged();
            }
        });
    }

    private void dialogChanged() {
        if (this.tCommonName.getText().length() <= 0) {
            this.lPreview.setText("");
            this.updateStatus(Messages.enterCommonName, 1);
            return;
        }
        this.lPreview.setText("CN=" + this.tCommonName.getText());
        if (this.tOrganizationalUnit.getText().length() > 0) {
            this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText());
        }
        if (this.tOrganization.getText().length() > 0) {
            this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText());
        }
        if (this.tLocation.getText().length() > 0) {
            this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText());
        }
        if (this.tState.getText().length() > 0) {
            this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText() + ", ST=" + this.tState.getText());
        }
        if (this.tCountry.getText().length() > 0) {
            this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText() + ", ST=" + this.tState.getText() + ", C=" + this.tCountry.getText());
        }
        if (this.tKeyName.getText().length() < 4) {
            this.updateStatus(Messages.enterNewKeyName, 1);
            return;
        }
        if (this.tKeyPassword.getText().length() < 6) {
            this.updateStatus(Messages.enterNewKeyPassword, 1);
            return;
        }
        if (this.cKeyAlgorithm.getSelectionIndex() < 0) {
            this.updateStatus(Messages.selectKeyAlgorithm, 1);
            return;
        }
        if (this.tKeystoreName.getText().length() > 0) {
            this.keystoreName = String.valueOf(this.tKeystoreName.getText()) + ".jks";
            this.keystorePath = String.valueOf(this.path) + System.getProperty("file.separator") + this.keystoreName;
            File tempFile = new File(this.keystorePath);
            if (tempFile.exists()) {
                this.updateStatus(Messages.keystoreAlreadyExists, 3);
                return;
            }
        } else {
            this.updateStatus(Messages.enterNewKeystoreName, 1);
            return;
        }
        if (this.tKeystorePassword.getText().length() < 6) {
            this.updateStatus(Messages.enterNewKeystorePassword, 1);
            return;
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (!this.generated && message == null) {
            this.bGenerate.setEnabled(true);
        } else {
            this.bGenerate.setEnabled(false);
        }
        this.setPageComplete(this.generated);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bGenerate) {
            this.createKeystore();
            this.updateStatus(null, 0);
        } else if (e.widget == this.bEchoKeystorePassword || e.widget == this.bEchoKeyPassword) {
            this.echoPassword(e);
        }
    }

    private void echoPassword(Event e) {
        if (e.widget == this.bEchoKeystorePassword) {
            if (this.tKeystorePassword.getEchoChar() == '*') {
                this.tKeystorePassword.setEchoChar('\u0000');
            } else {
                this.tKeystorePassword.setEchoChar('*');
            }
            this.tKeystorePassword.redraw();
        } else if (e.widget == this.bEchoKeyPassword) {
            if (this.tKeyPassword.getEchoChar() == '*') {
                this.tKeyPassword.setEchoChar('\u0000');
            } else {
                this.tKeyPassword.setEchoChar('*');
            }
            this.tKeyPassword.redraw();
        }
    }

    private void createKeystore() {
        HashMap<String, String> certificateData = new HashMap<String, String>();
        certificateData.put("CN", this.tCommonName.getText());
        certificateData.put("OU", this.tOrganizationalUnit.getText());
        certificateData.put("O", this.tOrganization.getText());
        certificateData.put("L", this.tLocation.getText());
        certificateData.put("ST", this.tState.getText());
        certificateData.put("C", this.tCountry.getText());
        try {
            this.keystore = new Keystore(this.keystorePath, this.tKeystorePassword.getText(), "JCEKS");
            this.keystore.store();
            this.keystore.load();
            KeyPair kp = this.keystore.generateKeyPair(this.cKeyAlgorithm.getText(), 512);
            Certificate[] certs = new Certificate[1];
            this.generated = this.keystore.insertPrivateKey(this.tKeyName.getText(), this.tKeyPassword.getText().toCharArray(), kp.getPrivate(), certs);
            this.keystore.store();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.generated = false;
            this.lResult.setText(Messages.keyGenerationFailed);
        }
        catch (Exception ex) {
            Utils.logError((Exception)ex, (String)"Signature keystore generation failed");
            this.generated = false;
            this.lResult.setText(Messages.keystoreGenerationFailed);
        }
        if (this.generated) {
            this.lResult.setText(NLS.bind((String)Messages.keystoreGenerated, (Object[])new Object[]{this.keystoreName, this.name}));
            this.updateStatus(null, 0);
        }
    }

    public void onEnterPage() {
        if (this.signature.getBsp()) {
            this.cKeyAlgorithm.setItems(Algorithms.SIGNATURE_KEY_ALGORITHMS_BSP);
            this.cKeyAlgorithm.select(0);
        } else {
            this.cKeyAlgorithm.setItems(Algorithms.SIGNATURE_KEY_ALGORITHMS);
            this.cKeyAlgorithm.select(0);
        }
        this.setMessage(null);
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PageAlgorithms page = ((NewSignatureWizard)this.getWizard()).getPageAlgorithms();
        page.onEnterPage();
        return page;
    }

    private void saveDataToModel() {
        this.signature.setKeystore(this.keystore);
        this.signature.setKeystorePassword(this.tKeystorePassword.getText().toCharArray());
        this.signature.setKeyPassword(this.tKeyPassword.getText().toCharArray());
        this.signature.setKeyName(this.tKeyName.getText());
        if (this.cKeyAlgorithm.getText().equals("DSA")) {
            this.signature.setKeyAlgorithm("SHA1withDSA");
        } else if (this.cKeyAlgorithm.getText().equals("EC")) {
            this.signature.setKeyAlgorithm("SHA1withECDSA");
        } else if (this.cKeyAlgorithm.getText().equals("RSA")) {
            this.signature.setKeyAlgorithm("SHA1withRSA");
        }
    }
}

