/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.sign.CreateSignature;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.commands.NewEncryptionCommand;
import org.eclipse.wst.xml.security.ui.sign.NewSignatureWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class NewSignatureCommand
extends AbstractHandler {
    private ITextSelection textSelection = null;
    private ExecutionEvent event;
    private IFile file = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.createSignature();
        return null;
    }

    private void createSignature() {
        try {
            NewSignatureWizard wizard = new NewSignatureWizard();
            IDocument document = null;
            if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
                final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
                if (editorPart.isDirty()) {
                    if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                        IRunnableWithProgress op = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                editorPart.doSave(monitor);
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        }
                        catch (InvocationTargetException ite) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                        }
                        catch (InterruptedException ie) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                        }
                    } else {
                        editorPart.doSaveAs();
                    }
                }
                this.textSelection = (ITextSelection)((ITextEditor)editorPart.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
                this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                document = (IDocument)editorPart.getAdapter(IDocument.class);
            } else {
                this.textSelection = null;
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                if (selection instanceof IStructuredSelection) {
                    this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
                }
            }
            if (this.file != null && this.file.isAccessible()) {
                if (this.textSelection != null && Utils.parseSelection((String)this.textSelection.getText())) {
                    wizard.init(this.file, this.textSelection);
                } else {
                    wizard.init(this.file);
                }
                CreateSignature signature = new CreateSignature();
                String fileLocation = "";
                if (document == null) {
                    fileLocation = this.file.getLocation().toString();
                }
                this.signData(signature, wizard, document, fileLocation);
                if (wizard.getModel().getLaunchEncryptionWizard()) {
                    this.callEncryptionWizard();
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewSignatureCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.NewSignatureCommand_1));
            }
        }
        catch (SAXParseException spe) {
            org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewSignatureCommand_0, Messages.NewSignatureCommand_2, spe);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewSignatureCommand_0, (String)Messages.NewSignatureCommand_3);
        }
        catch (IOException ioe) {
            org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewSignatureCommand_0, Messages.NewSignatureCommand_4, ioe);
        }
        catch (Exception ex) {
            org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewSignatureCommand_0, Messages.NewSignatureCommand_5, ex);
            org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during signing", ex);
        }
    }

    private void signData(final CreateSignature data, final NewSignatureWizard wizard, final IDocument document, final String file) throws Exception {
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job(Messages.NewSignatureCommand_0){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.NewSignatureCommand_7, 5);
                            Document doc = data.sign(wizard.getModel(), NewSignatureCommand.this.textSelection.getText(), monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                    break block8;
                                }
                                FileOutputStream fos = new FileOutputStream(file);
                                XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex) {
                                HandlerUtil.getActiveShell((ExecutionEvent)NewSignatureCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)NewSignatureCommand.this.event), Messages.NewSignatureCommand_0, Messages.NewSignatureCommand_8, ex);
                                        org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during signing", ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }

    private void callEncryptionWizard() throws ExecutionException {
        NewEncryptionCommand encrypt = new NewEncryptionCommand();
        encrypt.encryptAfterSignature(this.file);
        encrypt.execute(this.event);
    }

    public void signAfterEncryption(IFile encryptedFile) {
        this.file = encryptedFile;
        this.createSignature();
    }
}

