/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.encrypt.CreateEncryption;
import org.eclipse.wst.xml.security.core.encrypt.Encryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.dialogs.MissingPreferenceDialog;
import org.eclipse.wst.xml.security.ui.dialogs.PasswordDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class QuickEncryptionCommand
extends AbstractHandler {
    private ExecutionEvent event;
    private ITextSelection textSelection = null;
    private IFile file = null;
    private String resource;
    private String xpath = "";
    private String encryptionType;
    private String keyWrapAlgorithm;
    private String encryptionAlgorithm;
    private char[] keystorePassword;
    private String keyFile;
    private Keystore keystore;
    private String keyName;
    private char[] keyPassword;
    private String encryptionId;
    private boolean completePrefs = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.getPreferenceValues();
        if (this.checkPreferences()) {
            this.createEncryption();
        }
        return null;
    }

    private void createEncryption() {
        IDocument document = null;
        if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            if (editorPart.isDirty()) {
                if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            editorPart.doSave(monitor);
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (InvocationTargetException ite) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                    }
                    catch (InterruptedException ie) {
                        org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                    }
                } else {
                    editorPart.doSaveAs();
                }
            }
            this.textSelection = (ITextSelection)((ITextEditor)editorPart.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
            this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            document = (IDocument)editorPart.getAdapter(IDocument.class);
        } else {
            this.textSelection = null;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (selection instanceof IStructuredSelection) {
                this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
            }
        }
        PasswordDialog keystorePasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_1, "");
        if (keystorePasswordDialog.open() != 0) {
            return;
        }
        this.keystorePassword = keystorePasswordDialog.getValue().toCharArray();
        PasswordDialog privateKeyPasswordDialog = new PasswordDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_3, "");
        if (privateKeyPasswordDialog.open() != 0) {
            return;
        }
        this.keyPassword = privateKeyPasswordDialog.getValue().toCharArray();
        if (this.checkPasswords()) {
            try {
                if (this.loadKeystore()) {
                    if (this.file != null && this.file.isAccessible()) {
                        this.encryptData(document);
                    } else {
                        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickEncryptionCommand_4, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.QuickEncryptionCommand_5));
                    }
                } else {
                    MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickEncryptionCommand_4, (String)Messages.QuickEncryptionCommand_6);
                }
            }
            catch (SAXParseException spe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_7, spe);
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickEncryptionCommand_4, (String)Messages.QuickEncryptionCommand_8);
            }
            catch (IOException ioe) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_9, ioe);
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_10, ex);
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick encrypting", ex);
            }
        }
    }

    private void encryptData(final IDocument document) {
        final CreateEncryption encryption = new CreateEncryption();
        final Encryption data = new Encryption();
        data.setResource(this.resource);
        data.setEncryptionType(this.encryptionType);
        data.setXpath(this.xpath);
        data.setContent(false);
        data.setBsp(false);
        data.setKeyWrapAlgorithm(this.keyWrapAlgorithm);
        data.setEncryptionAlgorithm(this.encryptionAlgorithm);
        data.setKeystore(this.keystore);
        data.setKeystorePassword(this.keystorePassword);
        data.setKeyName(this.keyName);
        data.setKeyPassword(this.keyPassword);
        data.setEncryptionId(this.encryptionId);
        data.setFile(this.file.getLocation().toString());
        Job job = new Job(Messages.QuickEncryptionCommand_11){

            public IStatus run(IProgressMonitor monitor) {
                block8: {
                    try {
                        monitor.beginTask(Messages.QuickEncryptionCommand_12, 5);
                        Document doc = null;
                        doc = QuickEncryptionCommand.this.textSelection != null ? encryption.encrypt(data, QuickEncryptionCommand.this.textSelection.getText(), monitor) : encryption.encrypt(data, null, monitor);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            if (doc == null) break block8;
                            if (document != null) {
                                document.set(Utils.docToString((Document)doc, (boolean)false));
                                break block8;
                            }
                            FileOutputStream fos = new FileOutputStream(QuickEncryptionCommand.this.file.getLocation().toOSString());
                            XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception ex) {
                            HandlerUtil.getActiveShell((ExecutionEvent)QuickEncryptionCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)QuickEncryptionCommand.this.event), Messages.QuickEncryptionCommand_4, Messages.QuickEncryptionCommand_13, ex);
                                    org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during encrypting", ex);
                                }
                            });
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean loadKeystore() throws Exception {
        block3: {
            try {
                this.keystore = new Keystore(this.keyFile, this.keystorePassword.toString(), "JCEKS");
                this.keystore.load();
                if (this.keystore.containsKey(this.keyName)) break block3;
                return false;
            }
            catch (Exception ex) {
                org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during quick encryption", ex);
                return false;
            }
        }
        return this.keystore.getSecretKey(this.keyName, this.keyPassword) != null;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = XSTUIPlugin.getDefault().getPreferenceStore();
        this.resource = store.getString("encryptionResource");
        this.encryptionType = store.getString("encryptionType");
        this.keyWrapAlgorithm = store.getString("encryptionKeyWrap");
        this.encryptionAlgorithm = store.getString("encryptionEncryption");
        this.keyName = store.getString("encryptionKeyName");
        this.keyFile = store.getString("encryptionKeyStore");
        this.encryptionId = store.getString("encryptionID");
        if (this.resource != null && "xpath".equals(this.resource)) {
            this.xpath = store.getString("encryptionXPath");
        }
    }

    private boolean checkPreferences() {
        String title = Messages.QuickEncryptionCommand_4;
        int result = 2;
        if (this.resource == null || "".equals(this.resource)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickEncryptionCommand_14), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.resource != null && "xpath".equals(this.resource) && (this.xpath == null || this.xpath.equals(""))) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickEncryptionCommand_15), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else if (this.keyFile == null || "".equals(this.keyFile)) {
            result = this.showMissingParameterDialog(title, NLS.bind((String)Messages.MissingParameter, (Object)Messages.QuickEncryptionCommand_16), "org.eclipse.wst.xml.security.ui.preferences.Encryption");
        } else {
            this.completePrefs = true;
        }
        if (result == 0) {
            this.completePrefs = false;
            this.getPreferenceValues();
            this.checkPreferences();
        }
        return this.completePrefs;
    }

    private boolean checkPasswords() {
        if (this.keystorePassword == null || this.keystorePassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickEncryptionCommand_4, (String)Messages.QuickEncryptionCommand_1);
            return false;
        }
        if (this.keyPassword == null || this.keyPassword.length == 0) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.QuickEncryptionCommand_4, (String)Messages.QuickEncryptionCommand_3);
            return false;
        }
        return true;
    }

    private int showMissingParameterDialog(String title, String message, String prefId) {
        MissingPreferenceDialog dialog = new MissingPreferenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), title, message, prefId);
        return dialog.open();
    }
}

