/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.sign;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.sign.Messages;
import org.eclipse.wst.xml.security.ui.sign.NewSignatureWizard;
import org.eclipse.wst.xml.security.ui.sign.PageAlgorithms;

public class PageOpenKey
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "SignPageOpenKey";
    private String path;
    private Button bOpen = null;
    private Button bEchoKeystorePassword = null;
    private Button bEchoKeyPassword = null;
    private Text tKeystore = null;
    private Text tKeystorePassword = null;
    private Text tKeyPassword = null;
    private Text tKeyName = null;
    private String keyAlgorithm = "";
    private static final int LABELWIDTH = 120;
    private static final String SETTING_KEYSTORE = "sign_keystore";
    private static final String SETTING_KEY_NAME = "sign_key_name";
    private Signature signature = null;
    private Keystore keystore = null;

    public PageOpenKey(Signature signature, String path) {
        super(PAGE_NAME);
        this.setTitle(Messages.signatureTitle);
        this.setDescription(Messages.useKeyDescription);
        this.signature = signature;
        this.path = path;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.loadSettings();
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_signature_open_key");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gKeystore = new Group(parent, 16);
        gKeystore.setLayout((Layout)layout);
        gKeystore.setText(Messages.keystore);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKeystore.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.key);
        data = new FormData();
        data.top = new FormAttachment((Control)gKeystore, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Label lKeystore = new Label((Composite)gKeystore, 4);
        lKeystore.setText(Messages.name);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)gKeystore);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystore.setLayoutData((Object)data);
        this.tKeystore = new Text((Composite)gKeystore, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystore);
        data.width = 200;
        this.tKeystore.setLayoutData((Object)data);
        this.bOpen = new Button((Composite)gKeystore, 8);
        this.bOpen.setText(Messages.open);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystore, 10);
        this.bOpen.setLayoutData((Object)data);
        Label lKeystorePassword = new Label((Composite)gKeystore, 4);
        lKeystorePassword.setText(Messages.password);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 10);
        data.left = new FormAttachment((Control)gKeystore);
        data.width = 120;
        lKeystorePassword.setLayoutData((Object)data);
        this.tKeystorePassword = new Text((Composite)gKeystore, 0x400004);
        this.tKeystorePassword.setTextLimit(20);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystorePassword);
        data.width = 200;
        this.tKeystorePassword.setEchoChar('*');
        this.tKeystorePassword.setLayoutData((Object)data);
        Label lKeyName = new Label((Composite)gKey, 4);
        lKeyName.setText(Messages.name);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        data.width = 120;
        lKeyName.setLayoutData((Object)data);
        this.tKeyName = new Text((Composite)gKey, 4);
        this.tKeyName.setTextLimit(20);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyName);
        data.width = 200;
        this.tKeyName.setLayoutData((Object)data);
        Label lKeyPassword = new Label((Composite)gKey, 4);
        lKeyPassword.setText(Messages.password);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyName, 10);
        data.left = new FormAttachment((Control)gKey);
        data.width = 120;
        lKeyPassword.setLayoutData((Object)data);
        this.tKeyPassword = new Text((Composite)gKey, 0x400004);
        this.tKeyPassword.setTextLimit(20);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyPassword);
        data.width = 200;
        this.tKeyPassword.setEchoChar('*');
        this.tKeyPassword.setLayoutData((Object)data);
        this.bEchoKeystorePassword = new Button((Composite)gKeystore, 8);
        this.bEchoKeystorePassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystorePassword, 10);
        this.bEchoKeystorePassword.setLayoutData((Object)data);
        this.bEchoKeyPassword = new Button((Composite)gKey, 8);
        this.bEchoKeyPassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeyPassword, 10);
        this.bEchoKeyPassword.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.bOpen.addListener(13, (Listener)this);
        this.bEchoKeystorePassword.addListener(13, (Listener)this);
        this.bEchoKeyPassword.addListener(13, (Listener)this);
        this.tKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOpenKey.this.dialogChanged();
            }
        });
        this.tKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOpenKey.this.dialogChanged();
            }
        });
        this.tKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOpenKey.this.dialogChanged();
            }
        });
        this.tKeyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageOpenKey.this.dialogChanged();
            }
        });
    }

    private void dialogChanged() {
        block10: {
            if (this.tKeystore.getText().length() == 0) {
                this.updateStatus(Messages.selectKeyFile, 1);
                return;
            }
            if (this.tKeystorePassword.getText().length() == 0) {
                this.updateStatus(Messages.enterKeystorePassword, 1);
                return;
            }
            if (this.tKeyName.getText().length() == 0) {
                this.updateStatus(Messages.enterKeyName, 1);
                return;
            }
            if (this.tKeyPassword.getText().length() == 0) {
                this.updateStatus(Messages.enterKeyPassword, 1);
                return;
            }
            if (new File(this.tKeystore.getText()).exists()) {
                try {
                    this.keystore = new Keystore(this.tKeystore.getText(), this.tKeystorePassword.getText(), "JCEKS");
                    boolean loaded = this.keystore.load();
                    if (loaded) {
                        if (this.keystore.containsKey(this.tKeyName.getText())) {
                            if (this.keystore.getPrivateKey(this.tKeyName.getText(), this.tKeyPassword.getText().toCharArray()) == null) {
                                this.updateStatus(Messages.verifyKeyPassword, 3);
                                return;
                            }
                            break block10;
                        }
                        this.updateStatus(Messages.verifyKeyName, 3);
                        return;
                    }
                    this.updateStatus(Messages.verifyKeystorePassword, 3);
                    return;
                }
                catch (Exception exception) {
                    this.updateStatus(Messages.verifyAll, 3);
                    return;
                }
            }
            this.updateStatus(Messages.keystoreNotFound, 3);
            return;
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (message == null && this.getErrorMessage() == null) {
            this.setPageComplete(true);
            this.saveDataToModel();
        } else {
            this.setPageComplete(false);
        }
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bOpen) {
            this.openKeystore();
        } else if (e.widget == this.bEchoKeystorePassword || e.widget == this.bEchoKeyPassword) {
            this.echoPassword(e);
        }
    }

    private void echoPassword(Event e) {
        if (e.widget == this.bEchoKeystorePassword) {
            if (this.tKeystorePassword.getEchoChar() == '*') {
                this.tKeystorePassword.setEchoChar('\u0000');
            } else {
                this.tKeystorePassword.setEchoChar('*');
            }
            this.tKeystorePassword.redraw();
        } else if (e.widget == this.bEchoKeyPassword) {
            if (this.tKeyPassword.getEchoChar() == '*') {
                this.tKeyPassword.setEchoChar('\u0000');
            } else {
                this.tKeyPassword.setEchoChar('*');
            }
            this.tKeyPassword.redraw();
        }
    }

    private void openKeystore() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(Globals.KEY_STORE_EXTENSION_NAME);
        dialog.setFilterExtensions(Globals.KEY_STORE_EXTENSION);
        dialog.setFilterPath(this.path);
        String file = dialog.open();
        if (file != null && file.length() > 0) {
            this.tKeystore.setText(file);
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PageAlgorithms page = ((NewSignatureWizard)this.getWizard()).getPageAlgorithms();
        page.onEnterPage();
        return page;
    }

    private void saveDataToModel() {
        this.signature.setKeystore(this.keystore);
        this.signature.setKeyAlgorithm(this.keyAlgorithm);
        this.signature.setKeystorePassword(this.tKeystorePassword.getText().toCharArray());
        this.signature.setKeyPassword(this.tKeyPassword.getText().toCharArray());
        this.signature.setKeyName(this.tKeyName.getText());
    }

    private void loadSettings() {
        this.tKeystore.setText(this.getDialogSettings().get(SETTING_KEYSTORE) != null ? this.getDialogSettings().get(SETTING_KEYSTORE) : "");
        this.tKeyName.setText(this.getDialogSettings().get(SETTING_KEY_NAME) != null ? this.getDialogSettings().get(SETTING_KEY_NAME) : "");
    }

    protected void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTING_KEYSTORE, this.tKeystore.getText());
        settings.put(SETTING_KEY_NAME, this.tKeyName.getText());
    }
}

