/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.commands;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.xml.security.core.decrypt.CreateDecryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.commands.Messages;
import org.eclipse.wst.xml.security.ui.decrypt.NewDecryptionWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NewDecryptionCommand
extends AbstractHandler {
    private ExecutionEvent event;
    private IFile file = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        this.createDecryption();
        return null;
    }

    private void createDecryption() {
        try {
            NewDecryptionWizard wizard = new NewDecryptionWizard();
            IDocument document = null;
            if (HandlerUtil.getActivePart((ExecutionEvent)this.event) instanceof IEditorPart) {
                final IEditorPart editorPart = (IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)this.event);
                if (editorPart.isDirty()) {
                    if (editorPart.getTitle() != null && editorPart.getTitle().length() > 0) {
                        IRunnableWithProgress op = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                editorPart.doSave(monitor);
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)XSTUIPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        }
                        catch (InvocationTargetException ite) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ite);
                        }
                        catch (InterruptedException ie) {
                            org.eclipse.wst.xml.security.ui.utils.Utils.log("Error while saving editor content", ie);
                        }
                    } else {
                        editorPart.doSaveAs();
                    }
                }
                this.file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
                document = (IDocument)editorPart.getAdapter(IDocument.class);
            } else {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                if (selection instanceof IStructuredSelection) {
                    this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
                }
            }
            if (this.file != null && this.file.isAccessible()) {
                wizard.init(this.file);
                CreateDecryption decryption = new CreateDecryption();
                String fileLocation = "";
                if (document == null) {
                    fileLocation = this.file.getLocation().toString();
                }
                this.decryptData(decryption, wizard, document, fileLocation);
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.NewDecryptionCommand_0, (String)NLS.bind((String)Messages.RemoveReadOnlyFlag, (Object)Messages.NewDecryptionCommand_3));
            }
        }
        catch (Exception ex) {
            org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), Messages.NewDecryptionCommand_0, Messages.NewDecryptionCommand_1, ex);
            org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during decrypting", ex);
        }
    }

    private void decryptData(final CreateDecryption data, final NewDecryptionWizard wizard, final IDocument document, final String filename) throws Exception {
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)this.event), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job(Messages.NewDecryptionCommand_0){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.NewDecryptionCommand_2, 6);
                            Document doc = data.decrypt(wizard.getModel(), monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                    break block8;
                                }
                                FileOutputStream fos = new FileOutputStream(filename);
                                XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex) {
                                HandlerUtil.getActiveShell((ExecutionEvent)NewDecryptionCommand.this.event).getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        org.eclipse.wst.xml.security.ui.utils.Utils.showErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)NewDecryptionCommand.this.event), Messages.NewDecryptionCommand_0, Messages.NewDecryptionCommand_1, ex);
                                        org.eclipse.wst.xml.security.ui.utils.Utils.log("An error occured during decrypting", ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }
}

